/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.etl.skill.etl;

import com.ptteng.common.skill.model.Account;
import com.ptteng.common.skill.service.AccountService;
import com.ptteng.etl.skill.util.CheckDataUtil;
import com.ptteng.etl.skill.util.ConvertUtil;
import com.ptteng.etl.skill.util.JavaShellUtil;
import com.ptteng.etl.skill.util.PasswordUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class AccountEtl {
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 200L;
    private static final Log log = LogFactory.getLog((String)"autoScan");
    private long interval = 43200000L;
    private static Long label = 1L;
    private AccountService accountService;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    Long currentTime = System.currentTimeMillis();
                    log.info((Object)(" currentTime =============" + currentTime));
                    List accountIds = this.accountService.getExpireAccountIds(currentTime, Integer.valueOf(0), Integer.valueOf(100));
                    if (CollectionUtils.isEmpty((Collection)accountIds)) {
                        log.info((Object)"account-expire-etl don`t get any id ,sleep 200 ms ");
                        Thread.sleep(200L);
                        continue;
                    }
                    log.info((Object)("account-expire-etl get accountIds :" + accountIds.size()));
                    log.info((Object)("detail: " + accountIds));
                    List accountList = this.accountService.getObjectsByIds(accountIds);
                    this.dealExpireAccount(accountList);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(200L);
                log.error((Object)("process check expire-order error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    public void dealExpireAccount(List<Account> accountList) {
        try {
            for (Account account : accountList) {
                if (!CheckDataUtil.isNotNull(account)) continue;
                String pwd = PasswordUtil.getRandomS();
                log.info((Object)("old pwd :" + account.getPwd()));
                account.setStatus(Integer.valueOf(3));
                account.setNewPwd(pwd);
                log.info((Object)("new pwd :" + pwd));
                String shell = ConvertUtil.convertShell("sh", "/data/skill/javaShell/accountExpire.sh", account.getAccount(), pwd, account.getServerIp());
                JavaShellUtil.executeShell(shell);
                String logStr = ConvertUtil.convertLog(label.toString(), ": deal expire account with acountId=", account.getId().toString(), "  accountName=", account.getAccount(), "  new-pwd=", pwd);
                log.info((Object)logStr);
            }
            boolean isUpdate = this.accountService.updateList(accountList);
            if (isUpdate) {
                log.info((Object)" update success.");
            } else {
                log.info((Object)" update error.");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
        }
    }

    public Long getInterval() {
        return this.interval;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }
}

