/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.etl.skill.etl;

import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.model.Ctype;
import com.ptteng.common.skill.model.UserStatistics;
import com.ptteng.common.skill.service.CardService;
import com.ptteng.common.skill.service.CtypeService;
import com.ptteng.common.skill.service.UserStatisticsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class CardEtl {
    private static final int TASK_LEN = 200;
    private static final long SLEEP_MILLISECOND = 2000L;
    private static final Log log = LogFactory.getLog((String)"autoScan");
    private CardService cardService;
    private CtypeService ctypeService;
    private UserStatisticsService userStatisticsService;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    Long currentTime = System.currentTimeMillis();
                    log.info((Object)(" currentTime =============" + currentTime));
                    HashMap<String, Object> conditions = new HashMap<String, Object>();
                    conditions.put("status", 2);
                    conditions.put("expire_at & <=", currentTime);
                    conditions.put("@query", "id ");
                    conditions.put("@table", " card ");
                    List ids = this.cardService.getIdsByDynamicCondition(Card.class, conditions, Integer.valueOf(0), Integer.valueOf(200));
                    log.info((Object)("expire cards ids is: " + ids));
                    if (CollectionUtils.isEmpty((Collection)ids)) {
                        log.info((Object)"account-expire-etl don`t get any id ,sleep 2000 ms ");
                        Thread.sleep(2000L);
                        continue;
                    }
                    log.info((Object)("account-expire-etl get accountIds :" + ids.size()));
                    List cards = this.cardService.getObjectsByIds(ids);
                    for (Card card : cards) {
                        card.setStatus(Integer.valueOf(7));
                    }
                    this.cardService.updateList(cards);
                    this.setCardTypeStatistics(cards);
                    this.setUserStatistics(cards);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(2000L);
                log.error((Object)("process check expire-order error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private void setCardTypeStatistics(List<Card> cards) {
        ArrayList<Long> tids = new ArrayList<Long>();
        for (Card card : cards) {
            Long tid = card.getTid();
            tids.add(tid);
        }
        if (tids.size() == 0) {
            return;
        }
        try {
            List ctypes = this.ctypeService.getObjectsByIds(tids);
            for (Ctype ctype : ctypes) {
                ctype.setAssignCount(Integer.valueOf(ctype.getAssignCount() - 1));
                ctype.setExpiredCount(Integer.valueOf(ctype.getExpiredCount() + 1));
            }
            Boolean bl = this.ctypeService.updateList(ctypes);
            if (bl.booleanValue()) {
                log.info((Object)"update card type statistics success");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)"set card type statistics error.");
        }
    }

    private void setUserStatistics(List<Card> cards) {
        ArrayList<Long> uids = new ArrayList<Long>();
        for (Card card : cards) {
            Long oid = card.getOwnerId();
            uids.add(oid);
        }
        if (uids.size() == 0) {
            return;
        }
        try {
            List userStatistics = this.userStatisticsService.getObjectsByIds(uids);
            for (UserStatistics userStatistic : userStatistics) {
                userStatistic.setCardExpired(Integer.valueOf(userStatistic.getCardExpired() + 1));
                userStatistic.setCardUnused(Integer.valueOf(userStatistic.getCardUnused() - 1));
            }
            Boolean bl = this.userStatisticsService.updateList(userStatistics);
            if (bl.booleanValue()) {
                log.info((Object)"update user statistics success");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)"set user statistics error.");
        }
    }

    public CardService getCardService() {
        return this.cardService;
    }

    public void setCardService(CardService cardService) {
        this.cardService = cardService;
    }

    public CtypeService getCtypeService() {
        return this.ctypeService;
    }

    public void setCtypeService(CtypeService ctypeService) {
        this.ctypeService = ctypeService;
    }

    public UserStatisticsService getUserStatisticsService() {
        return this.userStatisticsService;
    }

    public void setUserStatisticsService(UserStatisticsService userStatisticsService) {
        this.userStatisticsService = userStatisticsService;
    }
}

