package com.ptteng.etl.skill.etl;

import com.ptteng.common.skill.model.Account;
import com.ptteng.common.skill.service.AccountService;
import com.ptteng.etl.skill.util.CheckDataUtil;
import com.ptteng.etl.skill.util.ConvertUtil;
import com.ptteng.etl.skill.util.JavaShellUtil;
import com.ptteng.etl.skill.util.PasswordUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

import java.util.Iterator;
import java.util.List;

/**
 * Created by ouyang on 2016/12/22.
 */
public class AccountEtl {

    private static final int TASK_LEN = 100;// 一次任务检测的条数

    private static final long SLEEP_MILLISECOND = 30000;// 空转任务间隔休息毫秒数

    private static final Log log = LogFactory.getLog("autoScan");

    private long interval = 12*60*60*1000; //等待时间12个小时

    private static Long label = 1L; //标签值,记录第X次实际更新

    private AccountService accountService;


    /**
     * ETL主进程
     * @throws InterruptedException
     */
    public void process() throws InterruptedException {

        while (true) {
            try {
                /* 获取到期时间点 */
                Long currentTime = System.currentTimeMillis();
                log.info(" currentTime =============" + currentTime);

                /* 获取超时订单,单次最多100条 */
                List<Long> accountIds = accountService.getExpireAccountIds(currentTime, 0, AccountEtl.TASK_LEN);

                /* 校验是否有超期accountIds */
                /* 没有,则休眠一段时间后再启动一次 */
                if (CollectionUtils.isEmpty(accountIds)) {
                    log.info("account-expire-etl don`t get any id ,sleep " + SLEEP_MILLISECOND + " ms ");
                    Thread.sleep(SLEEP_MILLISECOND);

                /* 有,则按accountIds获取订单进行处理 */
                } else {
                    log.info("account-expire-etl get accountIds :" + accountIds.size());
                    log.info("detail: " + accountIds);
                    List<Account> accountList = accountService.getObjectsByIds(accountIds);
                    dealExpireAccount(accountList);
                }

            } catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(SLEEP_MILLISECOND);
                log.error("process check expire-order error ,sleep " + t.getMessage());
            }
        }
    }

    /**
     * 处理过期账号
     * 1-修改account表记录
     * 2-调用脚本处理过期账号
     * @param accountList
     */
    public void dealExpireAccount(List<Account> accountList) {

        try {

            Iterator iterator = accountList.iterator();
            while (iterator.hasNext()) {
                Account account = (Account) iterator.next();
                if (CheckDataUtil.isNotNull(account)) {
                    /* 修改密码 */
                    String pwd = PasswordUtil.getRandomS();

                    /* 更新account */
                    account.setStatus(Account.Status_Expire);
                    account.setNewPwd(pwd);

                    /* 生成脚本 */
                    String shell = ConvertUtil.convertShell("sh", JavaShellUtil.basePath + "accountExpire.sh",
                            account.getAccount(), pwd, account.getServerIp());

                    /* 调用脚本,修改服务器密码,并把用户踢下线 */
                    JavaShellUtil.executeShell(shell);

                    String logStr = ConvertUtil.convertLog(label.toString(), ": deal expire account with acountId=",
                                                           account.getId().toString(), "  accountName=", account.getAccount(),
                                                           "  new-pwd=", pwd);
                    log.info(logStr);
                }
            }

            accountService.updateList(accountList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
        }
    }


    public Long getInterval() {
        return interval;
    }

    public AccountService getAccountService() {
        return accountService;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

}
