/**
 * 
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.skill.model.Timetable;
import com.ptteng.common.skill.service.TimetableService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class TimetableSCAClient implements TimetableService {

    private TimetableService timetableService;

	public TimetableService getTimetableService() {
		return timetableService;
	}
	
	
	public void setTimetableService(TimetableService timetableService) {
		this.timetableService =timetableService;
	}
	
	
			   
		@Override
		public Long insert(Timetable timetable)throws ServiceException, ServiceDaoException{
		
		return timetableService.insert(timetable);
		          
		
		}	
		  
    	   
		@Override
		public List<Timetable> insertList(List<Timetable> timetableList)throws ServiceException, ServiceDaoException{
		
		return timetableService.insertList(timetableList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return timetableService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Timetable timetable)throws ServiceException, ServiceDaoException{
		
		return timetableService.update(timetable);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Timetable> timetableList)throws ServiceException, ServiceDaoException{
		
		return timetableService.updateList(timetableList);
		          
		
		}	
		  
    	   
		@Override
		public Timetable getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return timetableService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Timetable> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return timetableService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getTimetableIdsByLessonId(Long lessonId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return timetableService.getTimetableIdsByLessonId(lessonId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getTimetableIdsByClassesId(Long classesId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return timetableService.getTimetableIdsByClassesId(classesId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countTimetableIdsByLessonId(Long lessonId)throws ServiceException, ServiceDaoException{
		
		return timetableService.countTimetableIdsByLessonId(lessonId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countTimetableIdsByClassesId(Long classesId)throws ServiceException, ServiceDaoException{
		
		return timetableService.countTimetableIdsByClassesId(classesId);
	
	
	}
	
		
	
		@Override
	public List<Long> getTimetableIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return timetableService.getTimetableIds(start, limit);
	}

	@Override
	public Integer countTimetableIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return timetableService.countTimetableIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return timetableService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return timetableService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   timetableService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.timetableService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

