package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Timetable;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface TimetableService extends BaseDaoService {

	



   		   
		
		public Long insert(Timetable timetable)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Timetable> insertList(List<Timetable> timetableList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Timetable timetable)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Timetable> timetableList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Timetable getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Timetable> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countTimetableIdsByLessonId(Long lessonId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countTimetableIdsByClassesId(Long classesId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getTimetableIdsByLessonId(Long lessonId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getTimetableIdsByClassesId(Long classesId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getTimetableIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countTimetableIds() throws ServiceException, ServiceDaoException;
	

}

