package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "lesson")
public class Lesson implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8134819906219040768L;	
	
		
	/**
	 *  上架状态
	 * 
	 */
	public static final Integer STATUS_ON = 1;
    	
	/**
	 *  下架状态
	 * 
	 */
	public static final Integer STATUS_OFF = 0;
    	
   
   /**
   *  主键,自增长id
   *
   */
    private  Long id;
	
  
   /**
   *  课时名称
   *
   */
    private  String name;
	
  
   /**
   *  课时id
   *
   */
    private  Long courseId;
	
  
   /**
   *  图片链接
   *
   */
    private  String img;
	
  
   /**
   *  视频链接
   *
   */
    private  String video;
	
  
   /**
   *  链接
   *
   */
    private  String url;
	
  
   /**
   *  回放封面
   *
   */
    private  String replayImg;
	
  
   /**
   *  回放内容
   *
   */
    private  String replayContent;
	
  
   /**
   *  宣传图片
   *
   */
    private  String promotionalImg;
	
  
   /**
   *  宣传内容
   *
   */
    private  String promotionalContent;
	
  
   /**
   *  课时介绍
   *
   */
    private  String intro;
	
  
   /**
   *  课时内容
   *
   */
    private  String content;
	
  
   /**
   *  状态
   *
   */
    private  Integer status;
	
  
   /**
   *  排序
   *
   */
    private  Integer sort;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  创建者
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  更新者
   *
   */
    private  Long updateBy;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "name")
	public String getName() {
		return name;
	}
	
	
	public void setName(String name) {
		this.name = name;
	}
		 	@Column(name = "course_id")
	public Long getCourseId() {
		return courseId;
	}
	
	
	public void setCourseId(Long courseId) {
		this.courseId = courseId;
	}
		 	@Column(name = "img")
	public String getImg() {
		return img;
	}
	
	
	public void setImg(String img) {
		this.img = img;
	}
		 	@Column(name = "video")
	public String getVideo() {
		return video;
	}
	
	
	public void setVideo(String video) {
		this.video = video;
	}
		 	@Column(name = "url")
	public String getUrl() {
		return url;
	}
	
	
	public void setUrl(String url) {
		this.url = url;
	}
		 	@Column(name = "replay_img")
	public String getReplayImg() {
		return replayImg;
	}
	
	
	public void setReplayImg(String replayImg) {
		this.replayImg = replayImg;
	}
		 	@Column(name = "replay_content")
	public String getReplayContent() {
		return replayContent;
	}
	
	
	public void setReplayContent(String replayContent) {
		this.replayContent = replayContent;
	}
		 	@Column(name = "promotional_img")
	public String getPromotionalImg() {
		return promotionalImg;
	}
	
	
	public void setPromotionalImg(String promotionalImg) {
		this.promotionalImg = promotionalImg;
	}
		 	@Column(name = "promotional_content")
	public String getPromotionalContent() {
		return promotionalContent;
	}
	
	
	public void setPromotionalContent(String promotionalContent) {
		this.promotionalContent = promotionalContent;
	}
		 	@Column(name = "intro")
	public String getIntro() {
		return intro;
	}
	
	
	public void setIntro(String intro) {
		this.intro = intro;
	}
		 	@Column(name = "content")
	public String getContent() {
		return content;
	}
	
	
	public void setContent(String content) {
		this.content = content;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}
	
	
	public void setSort(Integer sort) {
		this.sort = sort;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

