package com.ptteng.common.skill.DTO;

import com.gemantic.common.util.MyListUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 消息内容数据结构bean
 * @author: liu k
 * @create: 2019-11-02 10:27
 **/
public class MsgContent  implements Serializable {



  private static final long serialVersionUID = -8321137297914233171L;

  private  Integer version =1;

  //map key 为 msgConObj 的type
  private Map<String,MsgConObj> data;

  public MsgContent() {
  }

  public MsgContent(List<MsgConObj> list) throws NoSuchFieldException, IllegalAccessException {
    Map<String, MsgConObj> data = MyListUtil.convert2Map(MsgConObj.class.getDeclaredField("type"),list);
    this.data = data;
  }

  public MsgContent(Map<String, MsgConObj> data) {
    this.data = data;
  }

  public MsgContent(Integer version,
      Map<String, MsgConObj> data) {
    this.version = version;
    this.data = data;
  }

  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public Map<String, MsgConObj> getData() {
    return data;
  }

  public void setData(Map<String, MsgConObj> data) {
    this.data = data;
  }
  public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }
}
