package com.ptteng.common.skill.DTO;

import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description:
 * @author: liu k
 * @create: 2019-11-02 10:42
 **/
public class MsgConObj implements Serializable {

  /**
   * 消息对象参数类型约定 uname=用户名 uid=用户id mobile=手机号 time=时间戳 bid=分院id bname=分院名称 oid=职业id oname=职业名称 remark=备注
   * rebatch=返款批次 money=金额
   */
  public static final String TYPE_UNAME = "uname";
  public static final String TYPE_UID = "uid";
  public static final String TYPE_MOBILE = "mobile";


  public static final String TYPE_TIME = "time";

  public static final String TYPE_BID = "bid";
  public static final String TYPE_BNAME = "bname";

  public static final String TYPE_OID = "oid";
  public static final String TYPE_ONAME = "oname";

  public static final String TYPE_REMARK = "remark";

  public static final String TYPE_REBATCH = "rebatch";

  public static final String TYPE_MONEY = "money";


  /**
   * href 跳转约定 uid =跳转至用户信息相关页面 oid =跳转至职业信息相关页面 bid =跳转至分院信息相关页面
   */
  public static final String HREF_DEFAUTL = "";
  public static final String HREF_UID = "uid";
  public static final String HREF_OID = "oid";
  public static final String HREF_BID = "bid";


  private static final long serialVersionUID = -1303356884157996344L;
  private String type;

  private String value;

  private String href;

  public MsgConObj() {
  }

  public MsgConObj(String type, String value, String href) {
    this.type = type;
    this.value = value;
    this.href = href;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }
}
