package com.ptteng.common.skill.service;

import java.math.BigDecimal;
import java.util.*;

import com.ptteng.common.skill.model.User;
import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Task;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface TaskService extends BaseDaoService {

	



   		   
		
		public Long insert(Task task)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Task> insertList(List<Task> taskList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Task task)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Task> taskList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Task getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Task> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getTaskIdsByOid(Long oid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getTaskIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countTaskIds() throws ServiceException, ServiceDaoException;
	
    public Integer countTaskIdsByOid(Long oid) throws ServiceException, ServiceDaoException;


	/**
	 * 获取用户职业规划
	 * @param user
	 * @return
	 */
	Map<Long, LinkedList<Integer>> getUserPlanIdToStepIdListMapByTask(User user) throws ServiceException, ServiceDaoException;

	/**
	 * 根据 计划天数  步骤花费时间Map，其他步骤计算剩余任务时间，规划剩余任务步骤
	 * @param stepIdToConstTimeMap
	 * @param planId
	 * @return
	 */
	LinkedHashMap<Long, LinkedList<Integer>> assemblyPlanList(TreeMap<Integer, BigDecimal> stepIdToConstTimeMap,
																														Long planId,BigDecimal surplusTime);


	/**
	 * 获取用户对应职业所有资质的职业规划
	 * @param user 用户信息
	 */
	Map<Integer, Map<Long, LinkedList<Integer>>> getTalentToPlanIdToStepIdsMap(User user) throws ServiceException, ServiceDaoException;
}

