/**
 * 
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.skill.model.Lesson;
import com.ptteng.common.skill.service.LessonService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class LessonSCAClient implements LessonService {

    private LessonService lessonService;

	public LessonService getLessonService() {
		return lessonService;
	}
	
	
	public void setLessonService(LessonService lessonService) {
		this.lessonService =lessonService;
	}
	
	
			   
		@Override
		public Long insert(Lesson lesson)throws ServiceException, ServiceDaoException{
		
		return lessonService.insert(lesson);
		          
		
		}	
		  
    	   
		@Override
		public List<Lesson> insertList(List<Lesson> lessonList)throws ServiceException, ServiceDaoException{
		
		return lessonService.insertList(lessonList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return lessonService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Lesson lesson)throws ServiceException, ServiceDaoException{
		
		return lessonService.update(lesson);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Lesson> lessonList)throws ServiceException, ServiceDaoException{
		
		return lessonService.updateList(lessonList);
		          
		
		}	
		  
    	   
		@Override
		public Lesson getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return lessonService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Lesson> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return lessonService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getLessonIdsByCourseId(Long courseId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return lessonService.getLessonIdsByCourseId(courseId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getLessonIdsByCourseIdAndStatus(Long courseId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return lessonService.getLessonIdsByCourseIdAndStatus(courseId,status,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countLessonIdsByCourseId(Long courseId)throws ServiceException, ServiceDaoException{
		
		return lessonService.countLessonIdsByCourseId(courseId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countLessonIdsByCourseIdAndStatus(Long courseId,Integer status)throws ServiceException, ServiceDaoException{
		
		return lessonService.countLessonIdsByCourseIdAndStatus(courseId,status);
	
	
	}
	
		
	
		@Override
	public List<Long> getLessonIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return lessonService.getLessonIds(start, limit);
	}

	@Override
	public Integer countLessonIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return lessonService.countLessonIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return lessonService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return lessonService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   lessonService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.lessonService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

