package com.ptteng.common.skill.util;

import java.math.BigDecimal;

import com.gemantic.common.util.StringUtil;
import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.common.skill.model.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class UserUtil {


  /**
   * 只有内门，真传，长老和客卿才可以成为师兄
   *
   * @param identity
   * @return
   */
  public static boolean isTeacher(int identity) {
    boolean result = false;

    switch (identity) {

      case User.Identity_Offline:
        result = true;

        break;

      case User.Identity_chief:
        result = true;
        break;

      case User.Identity_Offical:
        result = true;

        break;

      case User.Identity_Elder:
        result = true;

        break;

      case User.Identity_Adviser:
        result = true;

        break;
      default:
        break;
    }

    return result;
  }


  public static int convertIdentity2Event(int identity) {
    int eventType = -1;
    switch (identity) {
      case User.Identity_Outside:
        eventType = Uevent.Event_Join_Outside;
        break;
      case User.Identity_Offline:
        eventType = Uevent.Event_Join_Offline;

        break;
      case User.Identity_Graduate:
        eventType = Uevent.Event_Graduate;

        break;
      case User.Identity_Work:
        eventType = Uevent.Event_Work;

        break;
      case User.Identity_Stop:
        eventType = Uevent.Event_Stop;

        break;
      case User.Identity_Hornour:
        eventType = Uevent.Event_Honour;

        break;
      case User.Identity_Offical:
        eventType = Uevent.Event_Offical;

        break;

      case User.Identity_Elder:
        eventType = Uevent.Event_Elder;

        break;

      case User.Identity_Adviser:
        eventType = Uevent.Event_Adviser;

        break;
      default:
        break;
    }
    return eventType;
  }


  /**
   * 根据用户的身份和分院来展示用户的名字 考虑到利用Core包的常量，暂不使用XML或其他的方式，直接在Util中写死
   * <p>
   * 无名：[无名弟子]昵称 退学：[无名弟子]昵称 散修：[散修弟子]职业—学号 外门：[外门弟子]职业—学号
   * <p>
   * <p>
   * 内门：[分院|内门弟子]职业—昵称 结业：[分院|结业师兄]职业—昵称 荣耀：[分院|荣耀师兄]职业—昵称 真传：[分院|真传弟子]职业—昵称
   * <p>
   * 长老：[修真长老]职业—昵称 客卿：[客卿长老]职业—昵称
   *
   * @param user
   * @param occupation
   * @param branchDetail
   * @return
   */
  public static String convertName(User user, BranchInstitute brach, Occupation occupation) {
    int identity = user.getIdentity();
    StringBuffer sb = new StringBuffer();
    sb = sb.append("[");
    // 1 分院为空或退学，退学不展示分院
    if (brach == null || identity == User.Identity_Stop || identity == User.Identity_Offical) {

    } else {
      sb = sb.append(brach.getName());
      sb = sb.append("|");
    }

    // 2 身份
    StringBuffer id_sb = new StringBuffer();
    StringBuffer id_nick = new StringBuffer();

    switch (identity) {

      case User.Identity_Unname:
        id_sb = id_sb.append("无名弟子");
        id_nick = id_nick.append(user.getNick());
        break;
      case User.Identity_Stop:
        id_sb = id_sb.append("无名弟子");
        id_nick = id_nick.append(user.getNick());
        break;
      case User.Identity_Online:
        id_sb = id_sb.append("散修弟子");
        id_nick = id_nick.append(user.getStudyNumber());
        break;
      case User.Identity_Outside:
        id_sb = id_sb.append("外门弟子");
        id_nick = id_nick.append(user.getStudyNumber());
        break;
      case User.Identity_Offline:
        id_sb = id_sb.append("内门弟子");
        id_nick = id_nick.append(user.getNick());
        break;
      case User.Identity_chief:
        id_sb = id_sb.append("首席弟子");
        id_nick = id_nick.append(user.getNick());
        break;
      case User.Identity_Graduate:
        id_sb = id_sb.append("结业弟子");
        id_nick = id_nick.append(user.getNick());
        break;

      case User.Identity_Hornour:
        id_sb = id_sb.append("荣耀师兄");
        id_nick = id_nick.append(user.getNick());
        break;
      case User.Identity_Offical:
        id_sb = id_sb.append("真传弟子");
        id_nick = id_nick.append(user.getNick());
        break;

      case User.Identity_Elder:
        id_sb = id_sb.append("修真长老");
        id_nick = id_nick.append(user.getNick());
        break;

      case User.Identity_Adviser:
        id_sb = id_sb.append("客卿长老");
        id_nick = id_nick.append(user.getNick());
        break;
      default:
        break;
    }

    sb = sb.append(id_sb);
    sb = sb.append("]");

    //3 职业
    if (occupation == null) {

    } else {
      sb = sb.append(occupation.getName());
      sb = sb.append("-");
    }

    //4 昵称
    sb = sb.append(id_nick);
    return sb.toString();
  }

  /**
   * 判断是否是线下 线下，首席 结业，荣耀，真传允许 都可以被称之为线下
   *
   * @param identity
   * @return
   */

  public static boolean isOffline(int identity) {

    boolean result = false;
    switch (identity) {

      case User.Identity_Offline:
        result = true;
        break;
      case User.Identity_chief:
        result = true;
        break;
      case User.Identity_Graduate:
        result = true;
        break;

      case User.Identity_Hornour:
        result = true;
        break;
      case User.Identity_Offical:
        result = true;
        break;

      default:
        break;
    }

    return result;
  }


  public static int convertHeadStatus2Event(int status) {
    int eventType = -1;
    switch (status) {
      case User.Head_Pratice:
        eventType = Uevent.Event_Pratice_Head;
        break;
      case User.Head_Offical:
        eventType = Uevent.Event_Head;

        break;

      default:
        break;
    }
    return eventType;
  }


  public static int convertReviewStatus2Event(int status) {
    int eventType = -1;
    switch (status) {
      case User.Review_Review:
        eventType = Uevent.Event_Review;
        break;

      default:
        break;
    }
    return eventType;
  }


  public static int convertLearnPhaseStatus2Event(int phase) {
    int eventType = -1;
    switch (phase) {
      case User.LEARN_PHASE_REAL:
        eventType = Uevent.Event_Start_Real;
        break;
      case User.LEARN_PHASE_REPLAY:
        eventType = Uevent.Event_Start_Replay;
        break;
      case User.LEARN_PHASE_TASK:

        break;
      default:


    }
    return eventType;
  }

  /**
   * 统计用户薪资
   *
   * @date 2019/9/12
   */
  public static Map<String, Object> getSalaryStatistics(Long oid,
      Integer branch,
      Integer identity,
      List<Integer> identityList,
      Long graduatedStartAt, Long graduatedEndAt,
      Long schoolId,
      Integer typicalStatus,
      boolean salaryStatic,
      List<Integer> salaryList,
      boolean count) {
    Map<String, Object> params = new HashMap<String, Object>();

    Set<String> tables = new HashSet();
    tables.add("user user");

    if (DataUtils.isNotNullOrEmpty(oid)) {
      params.put("user.oid", oid);
    }
    if (DataUtils.isNotNullOrEmpty(branch)) {
      params.put("user.branch", branch);
    }
    if (DataUtils.isNotNullOrEmpty(identity)) {
      params.put("user.identity", identity);
    }
    if (CollectionUtils.isNotEmpty(identityList)) {
      params.put("user.identity & in ", "(" + StringUtils.join(identityList, ",") + ")");
    }
    if (DataUtils.isNotNullOrEmpty(graduatedStartAt)) {
      params.put("user.graduate_at & >= ", graduatedStartAt);
    }
    if (DataUtils.isNotNullOrEmpty(graduatedEndAt)) {
      params.put("user.graduate_at & <= ", graduatedEndAt);

    }
    if (DataUtils.isNotNullOrEmpty(schoolId)) {
      params.put("user.school_id", schoolId);
    }
    if (DataUtils.isNotNullOrEmpty(typicalStatus)) {
      params.put("user.typical_status", typicalStatus);
    }

    if (count) {
      params.put("@query", " count( user.id) ");

    } else if (salaryStatic) {

      if (CollectionUtils.isEmpty(salaryList)) {
        Integer[] salarys = {0, 6, 8, 10, 12, 15};
        salaryList = Arrays.asList(salarys);
      }
      //排序
      Collections.sort(salaryList);
      //统计用户薪资 并按照范围分组
      params.put("user.salary & ", "is not null");
      params.put("@query",
          "elt(interval (user.salary," + StringUtils.join(salaryList, ",") + ")," + StringUtils
              .join(salaryList, ",") + "),count(user.id)");
      params.put("@group",
          "elt(interval (user.salary," + StringUtils.join(salaryList, ",") + ")," + StringUtils
              .join(salaryList, ",") + ")");
    } else {
      params.put("@query", " user.id ");
    }

    String table = SQLUtil.convertTable(tables);
    params.put("@table", table);

    /*
     * 打印sql语句 String convert2Sql = SQLUtil.convert2Sql(params, 0,
     * Integer.MAX_VALUE); System.out.println("语句："+convert2Sql);
     */
    return params;
  }


  /**
   * 获取结业用户身份 荣誉 线下 长老 结业 工作
   *
   * @date 2019/9/12
   */
  public static List<Integer> getComUserIdentities() {
    Integer[] comIds = new Integer[]{User.Identity_Hornour, User.Identity_Offical,
        User.Identity_Elder, User.Identity_Graduate, User.Identity_Work};
    return Arrays.asList(comIds);
  }

  /**
   * 获取在学用户身份 包括 内门 首席
   *
   * @date 2019/9/16
   */
  public static List<Integer> getStudyingUserIdentities() {
    //在学身份 内门40  首席50
    Integer[] stuIds = new Integer[]{User.Identity_Offline, User.Identity_chief};
    return Arrays.asList(stuIds);
  }


  /**
   * 初始化userInfo
   */
  public static UserInfo getInitUserInfo(long id) {
    UserInfo userInfo = new UserInfo();
    userInfo.setId(id);
    userInfo.setIeventId(0L);
    userInfo.setTuition(new BigDecimal("0"));
    userInfo.setRuleId(0L);
    userInfo.setPayType(UserInfo.PAY_TYPE_DEFAULT);
    userInfo.setStageStatus(UserInfo.STAGE_STATUS_NOT_OFF);
    userInfo.setOffAt(0L);
    userInfo.setInviteMoney(new BigDecimal("0"));
    userInfo.setIvMsgCount(0);
    userInfo.setCreateBy(id);
    userInfo.setUpdateBy(id);
    userInfo.setCreateAt(System.currentTimeMillis());
    userInfo.setUpdateAt(System.currentTimeMillis());
    return userInfo;
  }

  /**
   * 初始化asset
   */
  public static Asset getInitAsset(long id) {
    Asset asset = new Asset();
    asset.setId(id);
    asset.setAsset(new BigDecimal("0"));
    asset.setWithdraw(new BigDecimal("0"));
    asset.setWithdrawApply(new BigDecimal("0"));
    asset.setPreSettle(new BigDecimal("0"));
    asset.setSettle(new BigDecimal("0"));
    asset.setTotalInvite(new BigDecimal("0"));
    asset.setVersion(0);
    asset.setCreateBy(id);
    asset.setUpdateBy(id);
    asset.setUpdateAt(System.currentTimeMillis());
    asset.setCreateAt(System.currentTimeMillis());
    return asset;
  }

  /**
   * 统计用户邀请人数的方法 默认按月
   *
   * @param recommendId     邀请人id
   * @param inviteTimeStart 邀请起始时间 被邀请用户创建时间
   * @param inviteTimeEnd   邀请结束时间
   * @param groupBy         分组统计条件，默认按月
   * @Description:
   * @date 2019/10/19
   */
  public final static int InviteStatistics_groupByMonth = 1;

  public static Map<String, Object> getInviteStatistics(Long recommendId,
      Long inviteTimeStart,
      Long inviteTimeEnd, int groupBy) {
    Map<String, Object> params = new HashMap<>();
    Set<String> tables = new HashSet<>();
    tables.add("user user");
    tables.add("user_info user_info");
    params.put("user_info.id", "user.id");

    if (DataUtils.isNotNullOrEmpty(recommendId)) {
      params.put("user.recommend_id", recommendId);
    }
    if (DataUtils.isNotNullOrEmpty(inviteTimeStart)) {
      params.put("user.create_at & >=", inviteTimeStart);
    }
    if (DataUtils.isNotNullOrEmpty(inviteTimeEnd)) {
      params.put("user.create_at & <=", inviteTimeEnd);
    }
    String groupStr = "";
    switch (groupBy) {
      case InviteStatistics_groupByMonth:
        groupStr = "from_unixtime(user.create_at/1000,'%Y-%m')";
        break;
      default:
        groupStr = "from_unixtime(user.create_at/1000,'%Y-%m')";
        break;
    }
    params.put("@group", groupStr);
    params.put("@query", groupStr + ",count(1),sum(user_info.invite_money)");
    String table = SQLUtil.convertTable(tables);
    params.put("@table", table);
    return params;
  }


  // 从message表计算指定uid的isLook的值 方法参考 /a/u/message/unread/adjust
  // 20191116官网消息目前不包括活动大使资金相关消息 后期若开发再修改
  public static Map<String, Object> updateIsLook(long receiveId) {

    Map<String, Object> param = new HashMap<>();
    Set<String> tables = new HashSet<>();
    param.put("id", receiveId);
    param.put("@field", "user.is_look");
    StringBuffer sb = new StringBuffer();
    sb.append("(")
        .append(" select count(1) from message message where message.unread =")
        .append(Message.Status_Unread)
        .append("  and message.receive_id = user.id")
        .append("  and message.type != ").append("'").append(Message.COLLECTION_TYPE).append("'")
        .append("  and message.type != ").append("'").append(Message.LIKE_TYPE).append("'")
        .append("  and message.type != ").append("'").append(Message.PRIVATE_TYPE).append("'")
        .append("  and message.type != ").append("'").append(Message.TRADE_TYPE).append("'")
        .append(")");
    param.put("@value", sb.toString());
    param.put("@update", "user user");
    param.put("@table", "user user");
    return param;
  }

  // 20191116大使小程序消息目前只包括 大使+资金 相关消息 后期若开发再修改
  public static Map<String, Object> updateIvMsgCount(long receiveId) {

    Map<String, Object> param = new HashMap<>();
    Set<String> tables = new HashSet<>();
    param.put("id", receiveId);
    param.put("@field", "user_info.iv_msg_count");
    StringBuffer sb = new StringBuffer();
    sb.append("(")
        .append(" select count(1) from message message where message.unread =")
        .append(Message.Status_Unread)
        .append("  and message.receive_id = user_info.id")
        .append("  and message.type = ").append("'").append(Message.TRADE_TYPE).append("'")
        .append("  and message.type = ").append("'").append(Message.ENVOY_TYPE).append("'")
        .append(")");
    param.put("@value", sb.toString());
    param.put("@update", "user_info user_info");
    param.put("@table", "user_info user_info");
    return param;
  }


  public static void main(String[] args) {
    Map<String, Object> map = updateIvMsgCount(25397);
    String sql = SQLUtil.convert2Sql(map, 0, Integer.MAX_VALUE);
    System.out.println("sql = " + sql);
  }

}




