package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;



@Entity
@Table(name = "classes")
public class Classes implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2337114303510845440L;
    
    
    /**
     * 无班级
     */
    public static final String Type_None="none";

    /**
     * 线上散修
     */
    public static final String Type_Online="online";
    
    /**
     * 线上外门
     */
    public static final String Type_Outline="outline";
    
    /**
     * 线下内门
     */
    public static final String Type_Offline="offline";


    /**
     * 班级状态-满员
     */
	public static final Long Status_Full = 1L;
	
	
	/**
	 * 班级状态-未满员
	 */
	public static final Long Status_NotFull=0L;

    /**
     * 推出班级/结业时候，是否解除师兄弟关系
     * 1-解除师兄
     2-解除名下师弟
     3-同时解除师兄和名下师弟
     */
    public static final Integer RELIEVE_TEACHER=1;
    public static final Integer RELIEVE_STUDENT=2;
    public static final Integer RELIEVE_TEACHER_STUDENT=3;





    private Long id;


    private String name;


    private Long oid;


    private Long leader;


    private Long total;


    private Long qq;


    private String content;

   //期数
    private Long grade;


    private Long status;


    private String type;
    
    
    /**
     * 日报总数
     */
    private Integer dailyCount=0;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;

    private Integer branch;

    //辅导师兄id
    private Long tid;
    //关联文章id
    private Long articleId;
    //课程id
    private Long courseId;
    //班级名称
    private String title;
    //封面图片
    private String img;
    //课程开始日期
    private Long startAt;
    //课程结束日期
    private Long endAt;

    //上课类型
    private	Integer	lessonType;

    //上课时间
    private Long lessonStartAt;
    //下课时间
    private Long lessonEndAt;

  //存上课日期,每周的几号上课,每月的几号上课
  private String lessonDate;



  @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }
    @Column(name = "branch")
    public Integer getBranch() {
        return branch;
    }

    public void setBranch(Integer branch) {
        this.branch = branch;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "oid")
    public Long getOid() {
        return oid;
    }


    public void setOid(Long oid) {
        this.oid = oid;
    }

    @Column(name = "leader")
    public Long getLeader() {
        return leader;
    }

    public void setLeader(Long leader) {
        this.leader = leader;
    }

    @Column(name = "total")
    public Long getTotal() {
        return total;
    }


    public void setTotal(Long total) {
        this.total = total;
    }

    @Column(name = "qq")
    public Long getQq() {
        return qq;
    }


    public void setQq(Long qq) {
        this.qq = qq;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "grade")
    public Long getGrade() {
        return grade;
    }


    public void setGrade(Long grade) {
        this.grade = grade;
    }

    @Column(name = "status")
    public Long getStatus() {
        return status;
    }


    public void setStatus(Long status) {
        this.status = status;
    }
    
    
    
    @Column(name = "daily_count")
    public Integer getDailyCount() {
		return dailyCount;
	}


	public void setDailyCount(Integer dailyCount) {
		this.dailyCount = dailyCount;
	}


	@Column(name = "type")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }


    @Column(name = "tid")
    public Long getTid() {
      return tid;
    }

    public void setTid(Long tid) {
      this.tid = tid;
    }

    @Column(name = "article_id")
    public Long getArticleId() {
      return articleId;
    }

    public void setArticleId(Long articleId) {
      this.articleId = articleId;
    }

    @Column(name = "course_id")
    public Long getCourseId() {
      return courseId;
    }

    public void setCourseId(Long courseId) {
      this.courseId = courseId;
    }

    @Column(name = "title")
    public String getTitle() {
      return title;
    }

    public void setTitle(String title) {
      this.title = title;
    }

    @Column(name = "img")
    public String getImg() {
      return img;
    }

    public void setImg(String img) {
      this.img = img;
    }

    @Column(name = "start_at")
    public Long getStartAt() {
      return startAt;
    }

    public void setStartAt(Long startAt) {
      this.startAt = startAt;
    }

    @Column(name = "end_at")
    public Long getEndAt() {
      return endAt;
    }

    public void setEndAt(Long endAt) {
      this.endAt = endAt;
    }

    @Column(name = "lesson_type")
    public Integer getLessonType() {
      return lessonType;
    }

    public void setLessonType(Integer lessonType) {
      this.lessonType = lessonType;
    }

    @Column(name = "lesson_start_at")
    public Long getLessonStartAt() {
      return lessonStartAt;
    }

    public void setLessonStartAt(Long lessonStartAt) {
      this.lessonStartAt = lessonStartAt;
    }

    @Column(name = "lesson_end_at")
    public Long getLessonEndAt() {
      return lessonEndAt;
    }

    public void setLessonEndAt(Long lessonEndAt) {
      this.lessonEndAt = lessonEndAt;
    }

  @Column(name = "lesson_date")
  public String getLessonDate() {
    return lessonDate;
  }

  public void setLessonDate(String lessonDate) {
    this.lessonDate = lessonDate;
  }

  public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

