package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "asset_flow")
public class AssetFlow implements Serializable {


  private static final long serialVersionUID = 1726224119624707072L;

  /**
   * 20191105 流水号规则 1.设计规则：流水类型2位+类别2位+子类别2位+时间缀13位+随机码3位 2.例：微信提现0201021311644894906235
   * <p>
   * 流水类型： 收入：01 支出：02
   * <p>
   * 支出类别： 提现01
   * <p>
   * 支出子类别： 0 * 支付宝01 微信02 银行卡03
   * <p>
   * 收入类别： 技能树宣传大使01
   * <p>
   * 收入子类别： 线上学费01 线下学费02
   */
  public static final String NO_FLOW_TYPE_IN = "01";
  public static final String NO_FLOW_TYPE_OUT = "02";

  public static final String OUT_TYPE_WITHDRAW = "01";
  public static final String OUT_SUBTYPE_ALI = "01";
  public static final String OUT_SUBTYPE_WX = "02";
  public static final String OUT_SUBTYPE_BANK = "03";

  public static final String IN_TYPE_ENVOY = "01";
  public static final String IN_SUBTYPE_ONLINE = "01";
  public static final String IN_SUBTYPE_OFFLINE = "02";


  /**
   * flowType： 10=收入 20 = 支出
   */
  public static final Integer FLOW_TYPE_IN = 10;
  public static final Integer FLOW_TYPE_OUT = 20;

  /**
   * 流水交易类型 tradeType： 10=提现 20=技能树宣传大使返现
   */
  public static final Integer TRADE_TYPE_WITHDRAW = 10;
  public static final Integer TRADE_TYPE_REBATE = 20;

  /**
   * bizType 10=返款审核流水 20=提现审核流水
   */
  public static final Integer BIZTYPE_REBATE = 10;
  public static final Integer BIZTYPE_WITHDRAW = 20;

  /**
  * title 模板
  *
  */
  public  static final  String  TITLE_WITHDRAW="提现";
  public  static final  String  TITLE_REBATE="邀请{username}返款";
  public  static final  String  TITLE_REBATE_REPLACE="{username}";

  /**
   * payWay 支付方式  参考withdraw 类
   * 0=默认无
   * 10 =  大使小程序微信提现
   */
  public static final  Integer PAY_WAY_DEFAULT = 0;
  public static final  Integer PAY_WAY_WX_ENVOY = 10;



  private Long id;


  private Long uid;


  private String nick;


  private BigDecimal startMoney;


  private BigDecimal endMoney;


  private BigDecimal optionMoney;


  private Integer tradeType;


  private String title;


  private Integer payWay;


  private Integer flowType;


  private String content;


  private String flowNo;


  private Long payAt;


  private String remark;


  private Long bizId;


  private Integer bizType;


  private Long createBy;


  private Long updateBy;


  private Long updateAt;


  private Long createAt;


  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  @Column(name = "uid")
  public Long getUid() {
    return uid;
  }


  public void setUid(Long uid) {
    this.uid = uid;
  }

  @Column(name = "nick")
  public String getNick() {
    return nick;
  }


  public void setNick(String nick) {
    this.nick = nick;
  }

  @Column(name = "start_money")
  public BigDecimal getStartMoney() {
    return startMoney;
  }


  public void setStartMoney(BigDecimal startMoney) {
    this.startMoney = startMoney;
  }

  @Column(name = "end_money")
  public BigDecimal getEndMoney() {
    return endMoney;
  }


  public void setEndMoney(BigDecimal endMoney) {
    this.endMoney = endMoney;
  }

  @Column(name = "option_money")
  public BigDecimal getOptionMoney() {
    return optionMoney;
  }


  public void setOptionMoney(BigDecimal optionMoney) {
    this.optionMoney = optionMoney;
  }

  @Column(name = "trade_type")
  public Integer getTradeType() {
    return tradeType;
  }


  public void setTradeType(Integer tradeType) {
    this.tradeType = tradeType;
  }

  @Column(name = "title")
  public String getTitle() {
    return title;
  }


  public void setTitle(String title) {
    this.title = title;
  }

  @Column(name = "pay_way")
  public Integer getPayWay() {
    return payWay;
  }


  public void setPayWay(Integer payWay) {
    this.payWay = payWay;
  }

  @Column(name = "flow_type")
  public Integer getFlowType() {
    return flowType;
  }


  public void setFlowType(Integer flowType) {
    this.flowType = flowType;
  }

  @Column(name = "content")
  public String getContent() {
    return content;
  }


  public void setContent(String content) {
    this.content = content;
  }

  @Column(name = "flow_no")
  public String getFlowNo() {
    return flowNo;
  }


  public void setFlowNo(String flowNo) {
    this.flowNo = flowNo;
  }

  @Column(name = "pay_at")
  public Long getPayAt() {
    return payAt;
  }


  public void setPayAt(Long payAt) {
    this.payAt = payAt;
  }

  @Column(name = "remark")
  public String getRemark() {
    return remark;
  }


  public void setRemark(String remark) {
    this.remark = remark;
  }

  @Column(name = "biz_id")
  public Long getBizId() {
    return bizId;
  }


  public void setBizId(Long bizId) {
    this.bizId = bizId;
  }

  @Column(name = "biz_type")
  public Integer getBizType() {
    return bizType;
  }


  public void setBizType(Integer bizType) {
    this.bizType = bizType;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }


  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }

}

