/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.util;

import com.qding.common.util.DataUtils;
import com.qding.common.util.PropertiesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateUtils {
    private static final Log log = LogFactory.getLog(TemplateUtils.class);
    private static Properties props = new Properties();
    public static final String EVENT_register = "event.register";
    public static final String EVENT_occupation = "event.occupation";
    public static final String EVENT_daily = "event.daily";
    public static final String EVENT_offline = "event.offline";
    public static final String EVENT_outside = "event.outside";
    public static final String IV_msg_register = "iv.msg.register";
    public static final String IV_msg_offline = "iv.msg.offline";
    public static final String IV_msg_outside = "iv.msg.outside";
    public static final String IV_msg_occupation = "iv.msg.occupation";
    public static final String IV_msg_graduate = "iv.msg.graduate";
    public static final String IV_msg_quit = "iv.msg.quit";
    public static final String IV_msg_rewardPass = "iv.msg.rewardPass";
    public static final String IV_msg_rewardDeny = "iv.msg.rewardDeny";
    public static final String IV_msg_withdrawPass = "iv.msg.withdrawPass";
    public static final String IV_msg_withdrawDeny = "iv.msg.withdrawDeny";
    public static final String KEY_userNick = "{userNick}";
    public static final String KEY_mobile = "{mobile}";
    public static final String KEY_occupation = "{occupation}";
    public static final String KEY_branch = "{branch}";
    public static final String KEY_withdraw = "{withdraw}";
    public static final String KEY_date = "{date}";
    public static final String KEY_reason = "{reason}";
    public static final String KEY_batch = "{batch}";
    public static final String date_format = "yyyy.MM.dd";

    public static String getEventTemplate(int eventType, String userNick, String mobile, String occupation, String branch) {
        log.info((Object)("getEventTemplate template eventType = " + eventType + "userNick = " + userNick + "mobile =" + mobile + "occupation =" + occupation + "branch =" + branch));
        String template = "";
        String templateKey = "";
        switch (eventType) {
            case 1: {
                templateKey = EVENT_register;
                break;
            }
            case 2: {
                templateKey = EVENT_occupation;
                break;
            }
            case 31: {
                templateKey = EVENT_daily;
                break;
            }
            case 5: {
                templateKey = EVENT_offline;
                break;
            }
            case 6: {
                templateKey = EVENT_outside;
                break;
            }
            default: {
                templateKey = "";
            }
        }
        if (DataUtils.isNullOrEmpty((Object)templateKey)) {
            return template;
        }
        template = TemplateUtils.getProperty(templateKey);
        if (DataUtils.isNullOrEmpty((Object)template)) {
            template = "";
            return template;
        }
        if (userNick != null) {
            template = template.replace(KEY_userNick, userNick);
        }
        if (mobile != null) {
            StringBuilder sbuf = new StringBuilder(mobile);
            mobile = sbuf.replace(3, 7, "****").toString();
            template = template.replace(KEY_mobile, mobile);
        }
        if (occupation != null) {
            template = template.replace(KEY_occupation, occupation);
        }
        if (branch != null) {
            template = template.replace(KEY_branch, branch);
        }
        return template;
    }

    @Deprecated
    public static String getIVMsgTemplate(String messageSubType, String userNick, String mobile, String occupation, String branch, String date) {
        log.info((Object)("getIVEventTemplate template messageSubType = " + messageSubType + "userNick = " + userNick + "mobile =" + mobile + "occupation =" + occupation + "branch =" + branch + "date =" + date));
        String template = "";
        String templateKey = "";
        switch (messageSubType) {
            case "register": {
                templateKey = IV_msg_register;
                break;
            }
            case "occupation": {
                templateKey = IV_msg_occupation;
                break;
            }
            case "outside": {
                templateKey = IV_msg_outside;
                break;
            }
            case "offline": {
                templateKey = IV_msg_offline;
                break;
            }
            case "quit": {
                templateKey = IV_msg_quit;
                break;
            }
            case "graduate": {
                templateKey = IV_msg_graduate;
                break;
            }
            default: {
                templateKey = "";
            }
        }
        if (DataUtils.isNullOrEmpty((Object)templateKey)) {
            return template;
        }
        template = TemplateUtils.getProperty(templateKey);
        if (DataUtils.isNullOrEmpty((Object)template)) {
            template = "";
            return template;
        }
        if (userNick != null) {
            template = template.replace(KEY_userNick, userNick);
        }
        if (mobile != null) {
            StringBuilder sbuf = new StringBuilder(mobile);
            mobile = sbuf.replace(3, 7, "****").toString();
            template = template.replace(KEY_mobile, mobile);
        }
        if (occupation != null) {
            template = template.replace(KEY_occupation, occupation);
        }
        if (branch != null) {
            template = template.replace(KEY_branch, branch);
        }
        if (date != null) {
            template = template.replace(KEY_date, date);
        }
        return template;
    }

    @Deprecated
    public static String getIVTradeMsgTemplate(String messageSubType, String userNick, String mobile, Integer batch, BigDecimal withdraw, String reason, String date) {
        log.info((Object)("getIVTradeMsgTemplate template messageSubType = " + messageSubType + "userNick = " + userNick + "mobile =" + mobile + "batch =" + batch + "withdraw =" + withdraw + "reason =" + reason + "date =" + date));
        String template = "";
        String templateKey = "";
        switch (messageSubType) {
            case "rewardPass": {
                templateKey = IV_msg_rewardPass;
                break;
            }
            case "rewardDeny": {
                templateKey = IV_msg_rewardDeny;
                break;
            }
            case "withdrawPass": {
                templateKey = IV_msg_withdrawPass;
                break;
            }
            case "withdrawDeny": {
                templateKey = IV_msg_withdrawDeny;
                break;
            }
            default: {
                templateKey = "";
            }
        }
        if (DataUtils.isNullOrEmpty((Object)templateKey)) {
            return template;
        }
        template = TemplateUtils.getProperty(templateKey);
        if (DataUtils.isNullOrEmpty((Object)template)) {
            template = "";
            return template;
        }
        if (userNick != null) {
            template = template.replace(KEY_userNick, userNick);
        }
        if (mobile != null) {
            StringBuilder sbuf = new StringBuilder(mobile);
            mobile = sbuf.replace(3, 7, "****").toString();
            template = template.replace(KEY_mobile, mobile);
        }
        if (batch != null) {
            template = template.replace(KEY_batch, batch.toString());
        }
        if (withdraw != null) {
            template = template.replace(KEY_withdraw, withdraw.toString());
        }
        if (date != null) {
            template = template.replace(KEY_date, date);
        }
        if (reason != null) {
            template = template.replace(KEY_reason, reason);
        }
        return template;
    }

    public static String getProperty(String key) {
        return props.getProperty(key);
    }

    static {
        InputStream fis = PropertiesUtil.class.getClassLoader().getResourceAsStream("template.properties");
        try {
            props.load(fis);
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }
}

