package com.ptteng.common.skill.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.common.skill.model.UserInfo;
import java.util.List;
import org.osoa.sca.annotations.Remotable;

@Remotable
public interface UserInfoService extends BaseDaoService {

	



   		   
		
		public Long insert(UserInfo userInfo)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserInfo> insertList(List<UserInfo> userInfoList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(UserInfo userInfo)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<UserInfo> userInfoList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public UserInfo getObjectById(Long id)throws ServiceException, ServiceDaoException;


		/** 
		 * 非数据填充时不调用此初始化方法
		 * userInfo表数据填充，根据id查询，如果有就返回，如果没有，添加后再返回
		 * @param id 用户id 
		 * @Description:
		 * @date 2019/10/18
		*/
	  public UserInfo getObjectInitById(Long id)throws ServiceException, ServiceDaoException;

    	   
		
		public List<UserInfo> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;



	


				
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserInfoIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserInfoIds() throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Object updateIvMsgCount(Long uid) throws ServiceException, ServiceDaoException;
	

}

