package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Lesson;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface LessonService extends BaseDaoService {

	



   		   
		
		public Long insert(Lesson lesson)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Lesson> insertList(List<Lesson> lessonList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Lesson lesson)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Lesson> lessonList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Lesson getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Lesson> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countLessonIdsByCourseId(Long courseId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countLessonIdsByCourseIdAndStatus(Long courseId, Integer status)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getLessonIdsByCourseId(Long courseId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getLessonIdsByCourseIdAndStatus(Long courseId, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getLessonIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countLessonIds() throws ServiceException, ServiceDaoException;
	

}

