package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


/*
 *  constant为后台常量表   constants为公共常量
 */
@Entity
@Table(name = "constant")
public class Constant implements Serializable {

    /**
     * 环信
     */
    private static final long serialVersionUID = 7248626538052123648L;


	public static final String Type_EaseMob = "easemob";


	public static final String Name_Token = "token";


	/**
	 * 统计，用于首页
	 */
	public static final String Type_Statistics = "statistics";

    /**
     * 积分
     */
    public static final String Type_score = "score";

    /**
     * 咨询相关
     *
     */
    public static final String Type_advisory = "advisory";
    /**
     * 小程序订单
     *
     */
    public static final String Type_jnshu = "wx_jnshu";

    /**
     * 提现相关
     *
     */
    public static final String Type_withdraw = "withdraw";


	/**
	 * 班级数量
	 */
	public static final String Name_ClassCount = "classCount";


	/**
	 * 用户数量
	 */
	public static final String Name_UserCount = "userCount";


	/**
	 * 班级
	 */
	public static final String Type_Classes = "classes";

	/**
	* 微信accesstoken
	*
	*/
  public static final String Type_Wx_token = "wxAccesstoken";

	/**
	 * 班级的用户限制数
	 */
	public static final String Name_UserLimitCount = "userLimitCount";


    /**
     * 外门师兄服务单价
     */
    public static final String Price_Outline = "outlinePrice";


    /**
     * 单个师兄同时带外门师弟人数上限
     */
    public static final String Outline_Limit = "outlineLimit";

    /**
     * 日报评级学分
     */
    public static final String Name_dailyEvaluate = "dailyEvaluate";
    /**
     * 任务审核学分
     */
    public static final String Name_taskJudge = "taskJudge";

    /**
     * 上品日报积分
     */
    public static final String Name_dailyGood = "dailyGood";

    /**
     * 中品日报积分
     */
    public static final String Name_dailyMedium = "dailyMedium";

    /**
     * 上品日报积分
     */
    public static final String Name_dailyLow = "dailyLow";



    /**
    * 咨询订单名称
    *
    */
    public static final String Name_advisory_name = "advisoryName";



    /**
    * 咨询订单价格
    *
    */
    public static final String Name_advisory_price = "advisoryPrice";

    /**
     * 咨询订单催单次数
     *
     */
    public static final String Name_reminder_num = "reminderNum";

    /**
     * 提现-每天提现次数
     *
     */
    public static final String Name_withdrawNum_perDay = "withdrawNum";
    /**
     * 提现-每天提现金额
     *
     */
    public static final String Name_withdrawMoney_perDay = "withdrawMoney";
    /**
     * 提现-每天提现费率
     *
     */
    public static final String Name_withdrawMoney_rate = "withdrawRate";


    /**
    * 微信codeType 约定字段，未存入常量表
    *  advisory = 咨询小程序
     * envoy = 宣传使者小程序
    */
    public static final String WX_Advisory = "advisory";
    public static final String WX_Advisory_appId_key = "advisoryAppId";
    public static final String WX_Advisory_appSecret_key = "advisoryAppSecret";

    public static final String WX_Envoy = "envoy";
    public static final String WX_Envoy_appId_key = "envoyAppId";
    public static final String WX_Envoy_appSecret_key = "envoyAppSecret";

    public static final String WX_jnshu = "wx_jnshu";
    public static final String WX_jnshu_appId_key = "jnshuAppId";
    public static final String WX_jnshu_appSecret_key = "jnshuAppSecret";

    public static final String LOGIN_TYPE_MOBILE = "mobile";







    private Long id;


    private String name = "";


    private String value = "";


    private String type = "";

    private  String comments="";


    private Long createBy = 0L;


    private Long updateBy = 0L;


    private Long updateAt = 0L;


    private Long createAt = 0L;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "value")
    public String getValue() {
        return value;
    }


    public void setValue(String value) {
        this.value = value;
    }

    @Column(name = "type")
    public String getType() {
        return type;
    }


    public void setType(String type) {
        this.type = type;
    }

    @Column(name = "comments")
    public String getComments() {
        return comments;
    }


    public void setComments(String comments) {
        this.comments = comments;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

