package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "class_timetable")
public class ClassTimetable implements Serializable {


    private static final long serialVersionUID = 5160336492818302976L;

    /**
     * publishState 课堂发布状态：1 未发布  2 已发布
     */
    public static final int NOT_PUBLISHED = 1;
    public static final int PUBLISHED = 2;

    /**
     * speakStatus 课堂状态：1：预告未发布 2：预告已发布 3：未评级未提交审核 4：未评级已提交审核 5：已评级
     */
    public static final int APPOINT_NOT_PUBLISH = 1;
    public static final int APPOINT_PUBLISHED = 2;
    public static final int NO_LEVEL = 3;
    public static final int NO_LEVEL_UNSEND = 4;
        public static final int HAS_LEVEL = 5;

    /**
     * status 上下架(精选)状态 0：下架 1：上架 2：课表被删除后的状态（课表删除后，不影响小课堂的展示）
     */
    public static final int OFF_SHELF = 0;
    public static final int ON_SHELF = 1;
    public static final int TIMETABLE_DELETED = 2;

    /**
     * 最多上架数量
     */
    public static final int MAX_STATUS = 4;

    /**
     * type 前台我的课堂展示   0：我的课堂  1：师弟课堂   2：我的收藏  3:他人课堂 4.他人收藏
     */
    public static final int MINE_CLASS = 0;
    public static final int STUDENT_CLASS = 1;
    public static final int MINE_COLLECT = 2;
    public static final int OTHER_CLASS = 3;
    public static final int OTHER_COLLECT = 4;

    /**
     * 小课堂评级 1：下品 2：中品 3：上品
     */
    public static final int LOW_LEVEL = 1;
    public static final int MIDDLE_LEVEL = 2;
    public static final int HIGH_LEVEL = 3;

    /*小课堂相关的加分
     * 上品+2
     * 中品+1
     * 下品-3
     * 旷课-3
     * */
    public static final int LOW_LEVEL_SCORE = -3;
    public static final int MIDDLE_LEVEL_SCORE = 1;
    public static final int HIGH_LEVEL_SCORE = 2;
    public static final int ABSENT_SCORE = -3;

    /*积分变动的原因*/
    public static final String SMALL_CLASS_ABSENT_COMMENT = "小课堂旷课";
    public static final String SMALL_CLASS_HIGH_LEVEL_COMMENT = "小课堂被评为上品";
    public static final String SMALL_CLASS_MIDDLE_LEVEL_COMMENT = "小课堂被评为中品";
    public static final String SMALL_CLASS_LOW_LEVEL_COMMENT = "小课堂被评为下品";

    /**
     * 获取那种类型的数据："timetable"：获取课表   "classes"：获取小课堂
     */
    public static final String TYPE_TIMETABLE = "timetable";
    public static final String TYPE_CLASSES = "classes";


    /*用户是否点赞/收藏了课堂*/
    private boolean ifLike = false;
    private boolean ifCollection = false;

    private Long id;


    private Long arrangeDate;

    private Long thinkId;

    private Long reply;
    private Long lastReply;

    private Long classTeamId;


    private Long teachUid;


    //课堂发布状态：1：未发布  2：已发布
    private int publishState;


    //课程状态 1：预告 2：未审核 3：未评级 4：已评级
    private int speakStatus;


    private int level;


    private String comment;


    //上下架(精选)状态 0：下架 1：上架 2：课表删除后，小课堂也被假删除的状态
    private int status;


    private String leaveUid;


    private String absentUid;


    private int groupUserCount;


    private int collection;


    private int love;


    private int readCount;


    private int commentCount;


    private String pptUrl;


    private String videoUrl;


    private String content;


    private String targetPeople;


    private String expect;


    private String classAbstract;


    private String previewImg;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    private DeepThink deepThink;
    private String speakerTitle;



    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }


    @Column(name = "arrange_date")
    public Long getArrangeDate() {
        return arrangeDate;
    }


    public void setArrangeDate(Long arrangeDate) {
        this.arrangeDate = arrangeDate;
    }

    @Column(name = "reply")
    public Long getReply() {
        return reply;
    }


    public void setReply(Long reply) {
        this.reply = reply;
    }

    @Column(name = "last_reply")
    public Long getLastReply() {
        return lastReply;
    }

    public void setLastReply(Long lastReply) {
        this.lastReply = lastReply;
    }

    @Column(name = "think_id")
    public Long getThinkId() {
        return thinkId;
    }


    public void setThinkId(Long thinkId) {
        this.thinkId = thinkId;
    }


    @Column(name = "class_team_id")
    public Long getClassTeamId() {
        return classTeamId;
    }


    public void setClassTeamId(Long classTeamId) {
        this.classTeamId = classTeamId;
    }


    @Column(name = "teach_uid")
    public Long getTeachUid() {
        return teachUid;
    }


    public void setTeachUid(Long teachUid) {
        this.teachUid = teachUid;
    }


    @Column(name = "publish_state")
    public int getPublishState() {
        return publishState;
    }

    public void setPublishState(int publishState) {
        this.publishState = publishState;
    }


    @Column(name = "speak_status")
    public int getSpeakStatus() {
        return speakStatus;
    }


    public void setSpeakStatus(int speakStatus) {
        this.speakStatus = speakStatus;
    }

    @Column(name = "level")
    public int getLevel() {
        return level;
    }


    public void setLevel(int level) {
        this.level = level;
    }

    @Column(name = "comment")
    public String getComment() {
        return comment;
    }


    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name = "status")
    public int getStatus() {
        return status;
    }


    public void setStatus(int status) {
        this.status = status;
    }

    @Column(name = "leave_uid")
    public String getLeaveUid() {
        return leaveUid;
    }


    public void setLeaveUid(String leaveUid) {
        this.leaveUid = leaveUid;
    }

    @Column(name = "absent_uid")
    public String getAbsentUid() {
        return absentUid;
    }


    public void setAbsentUid(String absentUid) {
        this.absentUid = absentUid;
    }


    @Column(name = "group_user_count")
    public int getGroupUserCount() {
        return groupUserCount;
    }


    public void setGroupUserCount(int groupUserCount) {
        this.groupUserCount = groupUserCount;
    }

    @Column(name = "collection")
    public int getCollection() {
        return collection;
    }


    public void setCollection(int collection) {
        this.collection = collection;
    }

    @Column(name = "love")
    public int getLove() {
        return love;
    }


    public void setLove(int love) {
        this.love = love;
    }

    @Column(name = "read_count")
    public int getReadCount() {
        return readCount;
    }


    public void setCommentCount(int commentCount) {
        this.commentCount = commentCount;
    }


    @Column(name = "comment_count")
    public int getCommentCount() {
        return commentCount;
    }


    public void setReadCount(int readCount) {
        this.readCount = readCount;
    }

    @Column(name = "ppt_url")
    public String getPptUrl() {
        return pptUrl;
    }


    public void setPptUrl(String pptUrl) {
        this.pptUrl = pptUrl;
    }

    @Column(name = "video_url")
    public String getVideoUrl() {
        return videoUrl;
    }


    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "target_people")
    public String getTargetPeople() {
        return targetPeople;
    }


    public void setTargetPeople(String targetPeople) {
        this.targetPeople = targetPeople;
    }

    @Column(name = "expect")
    public String getExpect() {
        return expect;
    }


    public void setExpect(String extect) {
        this.expect = extect;
    }

    @Column(name = "class_abstract")
    public String getClassAbstract() {
        return classAbstract;
    }


    public void setClassAbstract(String classAbstract) {
        this.classAbstract = classAbstract;
    }

    @Column(name = "preview_img")
    public String getPreviewImg() {
        return previewImg;
    }


    public void setPreviewImg(String previewImg) {
        this.previewImg = previewImg;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Transient
    public boolean isIfLike() {
        return ifLike;
    }

    public void setIfLike(boolean ifLike) {
        this.ifLike = ifLike;
    }

    @Transient
    public boolean isIfCollection() {
        return ifCollection;
    }

    public void setIfCollection(boolean ifCollection) {
        this.ifCollection = ifCollection;
    }

    @Transient
    public DeepThink getDeepThink() { return deepThink;}

    public void setDeepThink(DeepThink deepThink) {
        this.deepThink = deepThink;
    }

    @Transient
    public String getSpeakerTitle() {
        return speakerTitle;
    }

    public void setSpeakerTitle(String speakerTitle) {
        this.speakerTitle = speakerTitle;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }



}

