package com.ptteng.common.skill.util;

import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.Uevent;
import com.ptteng.common.skill.model.User;

public class UserUtil {



	/**
	 * 只有内门，真传，长老和客卿才可以成为师兄
	 * @param identity
	 * @return
	 */
	public static boolean isTeacher(int identity) {
		boolean result=false;

		switch (identity) {
	
		case User.Identity_Offline:
			result=true;
			
			break;		
		
	
		case User.Identity_Offical:
			result=true;
			
			break;

		case User.Identity_Elder:
			result=true;
			
			break;
			
		case User.Identity_Adviser:
			result=true;
			
			break;
		default:
			break;
		}
	
	
		
		return result;
	}

	
	public static int convertIdentity2Event(int identity) {
		int eventType=-1;
		switch (identity) {
		case User.Identity_Outside:
			eventType=Uevent.Event_Join_Outside;				
			break;
		case User.Identity_Offline:
			eventType=Uevent.Event_Join_Offline;
			
			break;
		case User.Identity_Graduate:
			eventType=Uevent.Event_Graduate;
		
			break;
		case User.Identity_Work:
			eventType=Uevent.Event_Work;
		
			break;
		case User.Identity_Stop:
			eventType=Uevent.Event_Stop;
			
			break;
		case User.Identity_Hornour:
			eventType=Uevent.Event_Honour;
		
			break;
		case User.Identity_Offical:
			eventType=Uevent.Event_Offical;
			
			break;

		case User.Identity_Elder:
			eventType=Uevent.Event_Elder;
			
			break;
			
		case User.Identity_Adviser:
			eventType=Uevent.Event_Adviser;
			
			break;
		default:
			break;
		}
		return eventType;
	}


	/**
	 *根据用户的身份和分院来展示用户的名字
	 *考虑到利用Core包的常量，暂不使用XML或其他的方式，直接在Util中写死
	 *
	 *无名：[无名弟子]昵称
	 *退学：[无名弟子]昵称
     *散修：[散修弟子]职业—学号
     *外门：[外门弟子]职业—学号
     
     *
     *内门：[分院|内门弟子]职业—昵称
     *结业：[分院|结业师兄]职业—昵称
     *荣耀：[分院|荣耀师兄]职业—昵称
     *真传：[分院|真传弟子]职业—昵称
     *
     *长老：[修真长老]职业—昵称
     *客卿：[客卿长老]职业—昵称
	 * @param user
	 * @param occupation 
	 * @param branchDetail
	 * @return
	 */
	public static String convertName(User user, BranchInstitute brach, Occupation occupation) {
		 int identity=user.getIdentity();
	     StringBuffer sb=new StringBuffer();
	     sb=sb.append("[");
	     // 1 分院为空或退学，退学不展示分院
	     if(brach==null||identity==User.Identity_Stop||identity==User.Identity_Offical){
	    	 
	     }else{
	    	 sb=sb.append(brach.getName());
	    	 sb=sb.append("|");
	     }
	     
	     // 2 身份
	     StringBuffer id_sb=new StringBuffer();
	     StringBuffer id_nick=new StringBuffer();
	     
	     switch (identity){
	     
	        case User.Identity_Unname:
	    		id_sb=id_sb.append("无名弟子");	
	    		id_nick=id_nick.append(user.getNick());
				break;
	        case User.Identity_Stop:
				id_sb=id_sb.append("无名弟子");
				id_nick=id_nick.append(user.getNick());
				break;
	        case User.Identity_Online:
	    		id_sb=id_sb.append("散修弟子");	
	    		id_nick=id_nick.append(user.getStudyNumber());
				break;
	        case User.Identity_Outside:
	    		id_sb=id_sb.append("外门弟子");	
	    		id_nick=id_nick.append(user.getStudyNumber());
				break;
			case User.Identity_Offline:
				id_sb=id_sb.append("内门弟子");	
				id_nick=id_nick.append(user.getNick());
				break;
			case User.Identity_Graduate:
				id_sb=id_sb.append("结业弟子");
				id_nick=id_nick.append(user.getNick());
				break;
			
			case User.Identity_Hornour:
				id_sb=id_sb.append("荣耀师兄");
				id_nick=id_nick.append(user.getNick());
				break;
			case User.Identity_Offical:
				id_sb=id_sb.append("真传弟子");
				id_nick=id_nick.append(user.getNick());
				break;

			case User.Identity_Elder:
				id_sb=id_sb.append("修真长老");
				id_nick=id_nick.append(user.getNick());
				break;
				
			case User.Identity_Adviser:
				id_sb=id_sb.append("客卿长老");
				id_nick=id_nick.append(user.getNick());
				break;
			default:
				break;
			}
	     
	     
	     sb=sb.append(id_sb);
	     sb=sb.append("]");
	     
	     
	     //3 职业
        if(occupation==null){
	    	 
	     }else{
	    	 sb=sb.append(occupation.getName());
	    	 sb=sb.append("-");
	     }
        
         //4 昵称
        sb=sb.append(id_nick);
        return sb.toString();
	}

	/**
	 * 判断是否是线下
	 * 线下，结业，荣耀，真传允许 都可以被称之为线下
	 * @param identity
	 * @return
	 */

	public static boolean isOffline(int identity) {
		
		boolean result=false;
		 switch (identity){
	     


	     


			case User.Identity_Offline:
				result=true;
				break;
			case User.Identity_Graduate:
				result=true;
				break;


			case User.Identity_Hornour:
				result=true;
				break;
			case User.Identity_Offical:
				result=true;
				break;

		
			default:
				break;
			}
	     
	     return result;
	}


	public static int convertHeadStatus2Event(int status) {
		int eventType=-1;
		switch (status) {
		case User.Head_Pratice:
			eventType=Uevent.Event_Pratice_Head;				
			break;
		case User.Head_Offical:
			eventType=Uevent.Event_Head;
			
			break;
		
		default:
			break;
		}
		return eventType;
	}


	public static int convertReviewStatus2Event(int status) {
		int eventType=-1;
		switch (status) {
		case User.Review_Review:
			eventType=Uevent.Event_Review;				
			break;
				
		default:
			break;
		}
		return eventType;
	}


	public static int convertLearnPhaseStatus2Event(int phase) {
		int eventType=-1;
		 switch (phase){
         case User.LEARN_PHASE_REAL:
        	 eventType=Uevent.Event_Start_Real;
         break;
         case User.LEARN_PHASE_REPLAY:
        	 eventType=Uevent.Event_Start_Replay;
             break;
         case User.LEARN_PHASE_TASK:
        	
             break;
         default:
        	 
            
         
         }
		return eventType;
	}
}




