package com.ptteng.common.skill.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.common.skill.model.Article;
import com.ptteng.common.skill.model.Review;
import com.ptteng.common.skill.model.Uevent;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class UEventUtil {


    public static Map<String, Object> getDynamicParam(String ename, Long uid, String uname,
                                                      String uphone, Long eid,Long oid, Integer type, Long minHappenAt, Long maxHappenAt,  boolean count) {


        Map<String, Object> params = new HashMap<>();

        Set<String> tables = new HashSet();
        tables.add("uevent");


        if (StringUtils.isNotBlank(ename)) {
            params.put("uevent.name & like ", "'%" + ename + "%'");

        }

        if (uid != null) {
			tables.add("user");
            params.put("user.id", uid);
			params.put("uevent.uid", "user.id");
        }

        if (StringUtils.isNotBlank(uname)) {
            tables.add("user");
            params.put("user.nick & like ", "'%" + uname + "%'");
            params.put("uevent.uid", "user.id");

        }

        if (StringUtils.isNotBlank(uphone)) {
            tables.add("user");
            params.put("user.mobile", uphone);
            params.put("uevent.uid", "user.id");
        }
        
        if (oid != null) {
        	  tables.add("occupation");
        	  tables.add("user");
        	  params.put("occupation.id", oid);
        	  params.put("user.oid", "occupation.id");
        	  params.put("uevent.uid", "user.id");

        }
        
        if (type != null) {      	  
      	  params.put("uevent.type", type);

         }

        if (minHappenAt != null) {
            params.put("uevent.happen_at & >= ", minHappenAt);

        }
        if (maxHappenAt != null) {
            params.put("uevent.happen_at & <= ", maxHappenAt);


        }


        if (count) {
            params.put("@query", "count(uevent.id)");
        } else {
            params.put("@query", "uevent.id");
            params.put("@order", "uevent.happen_at desc ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;

    }

	public static int convert2UEventType(int size) {
		
			int eventType=-1;
			switch (size) {
			case 0:
				eventType=Uevent.Event_First_Daily;
				break;
			case 1:
				eventType=Uevent.Event_Second_Daily;
				break;		
			case 2:
				eventType=Uevent.Event_Three_Daily;
				break;	

			default:
				break;
			}
			return eventType;
		}

	/**
	 * 判断是否满足七天报名条件，一个月内连续7天且5篇以上中品
	 * @param articles
	 * @return
	 */
	public static boolean isAllowAble(List<Article> articles) {
		if (articles.size()<7){
			return  false;
		}
		//查看前7篇日报是否连续
		for (int i=0;i<6;i++){
			if (getBeApartDay(articles.get(i).getCreateAt(),articles.get(i+1).getCreateAt())>1){
				List<Article>  articleList=articles.subList(i+1,articles.size());
               	isAllowAble(articleList);
			}
		}
		//日报等级：1-下品 2-中品 3-上品
		//查看连续7篇日报是否有5篇中品以上
		int count =0;
		for (int i=0;i<7;i++){
		if (isGooddaily(articles.get(i).getEvaluation())){
				count=count+1;
			}
		}
		if (count>=5){
			return true;
		}else {
			List<Article>  articleList=articles.subList(1,articles.size());
			isAllowAble(articleList);
		}

		return false;
	}

	 private static  boolean isGooddaily(Integer integer){
		if (integer==null){
			return false;
		}
		 if (integer==2||integer==3){
			 return true;
		 }
		 return false;
	 }


	public static int convertReviewType2EventType(Review review) {
		int eventType=-1;
		switch (review.getType()) {
		case Review.Type_Replay:
			eventType=Uevent.Event_Start_Replay;
			break;

		case Review.Type_Real:
			eventType=Uevent.Event_Start_Real;
			break;

		default:
			break;
		}
		return eventType;
	}
	public static void main(String[] args) {
		Map<String, Object> paramList = UEventUtil.getDynamicParam(  null,  null,  null,
				null,  null,  null,null,null,  1L, false);
		System.out.println(paramList);
	}





	/** 相差和相隔的区别，例：2019-05-09 23:59:59和2019-05-10 00:00:00 两者相差0天，相隔1天。
	 * @param begin 开始时间
	 * @param end   结束时间
	 * @return 获得两个时间相隔的天数（通过获取两个时间点当天0点的时间戳计算比对相隔天数）
	 */
	public static long getBeApartDay(long begin, long end) {

		Long begindate = getOneDayBeginTimeInMillis(begin,0);
		Long enddate =getOneDayBeginTimeInMillis(end,0);
		int a = 60 * 60 * 24 * 1000;
		if (begindate > enddate) {
			return (begindate - enddate) / a;
		}
		if (begindate< enddate) {
			return (enddate- begindate) / a;
		}
		return 0;
	}

	/**
	 * @param time 指定时间
	 * @param day  距指定日期的天数
	 * @return 得到今年本日x天前（后）天的开始时间   负数为指定日期之前，正数为指定日期之后
	 */
	public static long getOneDayBeginTimeInMillis(long time, int day) {
		Calendar c = new GregorianCalendar();
		Date date = new Date(time);
		c.setTime(date);
		c.add(Calendar.DATE, day);
		c.set(Calendar.HOUR_OF_DAY, 0);
		c.set(Calendar.MINUTE, 0);
		c.set(Calendar.SECOND, 0);
		c.set(Calendar.MILLISECOND, 0);
		return c.getTimeInMillis();
	}


}




