package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.UserDocumentRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface UserDocumentRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(UserDocumentRelation userDocumentRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserDocumentRelation> insertList(List<UserDocumentRelation> userDocumentRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(UserDocumentRelation userDocumentRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<UserDocumentRelation> userDocumentRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public UserDocumentRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserDocumentRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserDocumentRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserDocumentRelationIdsByDocumentId(Long documentId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserDocumentRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserDocumentRelationIdsByUidAndStatus(Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserDocumentRelationIdsByUidAndStatusAndWhether(Long uid, Integer type, Integer status,Integer whether,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserDocumentRelationIdsByUidAndStatus(Long uid,Integer status)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserDocumentRelationIdsByUidAndStatusAndWhether(Long uid, Integer type, Integer status,Integer whether)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserDocumentRelationIdsByUidAndType(Long uid,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserDocumentRelationIdsByDocumentId(Long documentId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getUserDocumentRelationIdByUidAndDocumentId(Long uid,Long documentId)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getUserDocumentRelationIdByUidAndDocumentIdAndStatus(Long uid,Long documentId,Integer status)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(Long uid,Long documentId,Integer status,Integer whether)throws ServiceException, ServiceDaoException;


	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserDocumentRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserDocumentRelationIds() throws ServiceException, ServiceDaoException;
	

}

