package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;

@Entity
@Table(name = "uevent")
public class Uevent implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7877770319875502080L;

	/**
	 * 注册
	 */
	public static final int Event_Register = 1;

	/**
	 * 加入班级
	 */
	public static final int Event_Join_Class = 2;

	/**
	 * 领取任务
	 */
	public static final int Event_Get_Task = 3;

	

	/**
	 * 加入内门
	 */
	public static final int Event_Join_Offline = 5;

	/**
	 * 加入外门
	 */
	public static final int Event_Join_Outside = 6;

	/**
	 * 进入复盘
	 */
	public static final int Event_Start_Replay = 7;

	/**
	 * 进入真实
	 */
	public static final int Event_Start_Real = 8;

	/**
	 * 结业
	 */
	public static final int Event_Graduate = 9;

	/**
	 * 入职
	 */
	public static final int Event_Work = 10;

	/**
	 * 成为荣耀师兄
	 */
	public static final int Event_Honour = 11;

	/**
	 * 成为首席师兄
	 */
	public static final int Event_Head = 12;

	/**
	 * 进入考察期
	 */
	public static final int Event_Review = 13;

	/**
	 * 成为见习首席师兄
	 */
	public static final int Event_Pratice_Head = 14;

	/**
	 * 退学
	 */
	public static final int Event_Stop = 15;

	/**
	 * 开始休学
	 */
	public static final int Event_Pause = 16;
	/**
	 * 休学结束
	 */
	public static final int Event_Continue = 17;
	
	/**
	 * 成为真传
	 */
	public static final int Event_Offical = 18;
	/**
	 * 成为长老
	 */
	public static final int Event_Elder= 19;
	/**
	 * 成为客卿
	 */
	public static final int Event_Adviser = 20;
	
	
	
	/**
	 * 第一篇日报
	 */
	public static final int Event_First_Daily = 31;
	/**
	 * 第二篇日报
	 */
	public static final int Event_Second_Daily = 32;
	/**
	 * 第三篇日报
	 */
	public static final int Event_Three_Daily = 33;
	
	/**
	 * 连续七天日报
	 */
	public static final int Event_Seven_Daily = 37;
	
	

	private Long id;

	/**
	 * 类型
	 */
	private Integer type;

	private Long uid;

	private String remark;

	private Long happenAt;

	private Long createBy;

	private Long updateBy;

	private Long updateAt;

	private Long createAt;
	
	
	

	public Uevent() {
		super();
		// TODO Auto-generated constructor stub
	}



	/**
	 * 
	 * @param uid
	 * @param type
	 * @param happenAt
	 * @param remark
	 */
	public Uevent( Long uid,Integer type, Long happenAt ,String remark) {
		super();
		this.type = type;
		this.uid = uid;
		this.remark = remark;
		this.happenAt = happenAt;
	}
	
	

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name = "id")
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@Column(name = "uid")
	public Long getUid() {
		return uid;
	}

	public void setUid(Long uid) {
		this.uid = uid;

	}

	@Column(name = "type")
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	@Column(name = "remark")
	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	@Column(name = "happen_at")
	public Long getHappenAt() {
		return happenAt;
	}

	public void setHappenAt(Long happenAt) {
		this.happenAt = happenAt;
	}

	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}

	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}

	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}

	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}

	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}

	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}

	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}

	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}
