/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.common.skill.model.Article;
import com.ptteng.common.skill.model.Review;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UEventUtil {
    public static Map<String, Object> getDynamicParam(String ename, Long uid, String uname, String uphone, Long eid, Long oid, Integer type, Long minHappenAt, Long maxHappenAt, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("uevent");
        if (StringUtils.isNotBlank((CharSequence)ename)) {
            params.put("uevent.name & like ", "'%" + ename + "%'");
        }
        if (uid != null) {
            tables.add("user");
            params.put("user.id", uid);
            params.put("uevent.uid", "user.id");
        }
        if (StringUtils.isNotBlank((CharSequence)uname)) {
            tables.add("user");
            params.put("user.nick & like ", "'%" + uname + "%'");
            params.put("uevent.uid", "user.id");
        }
        if (StringUtils.isNotBlank((CharSequence)uphone)) {
            tables.add("user");
            params.put("user.mobile", uphone);
            params.put("uevent.uid", "user.id");
        }
        if (oid != null) {
            tables.add("occupation");
            tables.add("user");
            params.put("occupation.id", oid);
            params.put("user.oid", "occupation.id");
            params.put("uevent.uid", "user.id");
        }
        if (type != null) {
            params.put("uevent.type", type);
        }
        if (minHappenAt != null) {
            params.put("uevent.happen_at & >= ", minHappenAt);
        }
        if (maxHappenAt != null) {
            params.put("uevent.happen_at & <= ", maxHappenAt);
        }
        if (count) {
            params.put("@query", "count(uevent.id)");
        } else {
            params.put("@query", "uevent.id");
            params.put("@order", "uevent.happen_at desc ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static int convert2UEventType(int size) {
        int eventType = -1;
        switch (size) {
            case 0: {
                eventType = 31;
                break;
            }
            case 1: {
                eventType = 32;
                break;
            }
            case 2: {
                eventType = 33;
                break;
            }
        }
        return eventType;
    }

    public static boolean isAllowAble(List<Article> articles) {
        if (articles.size() < 7) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (UEventUtil.getBeApartDay(articles.get(i).getCreateAt(), articles.get(i + 1).getCreateAt()) <= 1L) continue;
            List<Article> articleList = articles.subList(i + 1, articles.size());
            UEventUtil.isAllowAble(articleList);
        }
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            if (!UEventUtil.isGooddaily(articles.get(i).getEvaluation())) continue;
            ++count;
        }
        if (count >= 5) {
            return true;
        }
        List<Article> articleList = articles.subList(1, articles.size());
        UEventUtil.isAllowAble(articleList);
        return false;
    }

    private static boolean isGooddaily(Integer integer) {
        if (integer == null) {
            return false;
        }
        return integer == 2 || integer == 3;
    }

    public static int convertReviewType2EventType(Review review) {
        int eventType = -1;
        switch (review.getType()) {
            case 10: {
                eventType = 7;
                break;
            }
            case 20: {
                eventType = 8;
                break;
            }
        }
        return eventType;
    }

    public static void main(String[] args) {
        Map<String, Object> paramList = UEventUtil.getDynamicParam(null, null, null, null, null, null, null, null, 1L, false);
        System.out.println(paramList);
    }

    public static long getBeApartDay(long begin, long end) {
        Long begindate = UEventUtil.getOneDayBeginTimeInMillis(begin, 0);
        Long enddate = UEventUtil.getOneDayBeginTimeInMillis(end, 0);
        int a = 86400000;
        if (begindate > enddate) {
            return (begindate - enddate) / (long)a;
        }
        if (begindate < enddate) {
            return (enddate - begindate) / (long)a;
        }
        return 0L;
    }

    public static long getOneDayBeginTimeInMillis(long time, int day) {
        GregorianCalendar c = new GregorianCalendar();
        Date date = new Date(time);
        c.setTime(date);
        ((Calendar)c).add(5, day);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }
}

