package com.ptteng.common.skill.util;

import com.ptteng.common.dao.util.SQLUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WeekUtil {

    /**
     * @param wid     周会ID    
     * @param branchID     分院ID
     * @param uid     用户ID   
     * @param unick     用户昵称   
     * @param uphone     用户手机号   
     * @param occouptionID     职业ID  
     * @param weekStartAt     周开始时间
     * @param weekEndAt     周结束时间   
     * @param seniorID     师兄ID   
     * @param seniorNick     师兄昵称  
     * @param seniorPhone     师兄手机号   
     * @param headID     分院负责人ID 
     * @param headPhone	分院负责人手机号
     * @param heandNick	分院负责人昵称	
     * @param symptomID	症状ID	
     * @param symptiomName	症状名称	
     * @param stypeID	症状类别ID    
     * @param stypeName  
     * @param count
     * @return
     */
    public static Map<String, Object> getDynamicParam(Long wid,Long branchID,String branchName,Long uid,String unick,
                                                      String uphone,Long occouptionID,Long minWeekStartAt,Long maxWeekStartAt,Long minWeekEndAt,Long maxWeekEndAt,Long seniorID
                                                      ,String seniorNick,String seniorPhone,Long headID,String headPhone
                                                      ,String headNick,Long sid,String sname,Long tid,String tname,boolean count){


        Map<String, Object> params = new HashMap<>();

        Set<String> tables = new HashSet();
        tables.add("week");
        if (wid!=null) {

            params.put("week.id", wid);

        }
        if (branchID!=null) {
            tables.add("user");
            params.put("user.branch", branchID);
            params.put("week.uid", "user.id");

        }

        //params.put(" a.nick & like ", "'%" + nick + "%'");

        if (StringUtils.isNotBlank(branchName)) {
            tables.add("user");
            tables.add("branch_institute");
            params.put("branch_institute.name & like ", "'%" + branchName + "%'");
            params.put("user.branch", "branch_institute.id");
            params.put("week.uid", "user.id");

        }

        if (uid!=null) {
            params.put("week.uid", uid);

        }

        if (StringUtils.isNotBlank(unick)) {
            tables.add("user");
            params.put("user.nick & like ", "'%" + unick + "%'");
            params.put("week.uid", "user.id");

        }

        if (StringUtils.isNotBlank(uphone)) {
            tables.add("user");
            params.put("user.mobile", uphone);
            params.put("week.uid", "user.id");

        }

        if (occouptionID!=null) {
            tables.add("user");
            params.put("user.oid", occouptionID);
            params.put("week.uid", "user.id");

        }


        if (StringUtils.isNotBlank(uphone)) {
            tables.add("user");
            params.put("user.mobile", uphone);
            params.put("week.uid", "user.id");

        }
        if (StringUtils.isNotBlank(uphone)) {
            tables.add("user");
            params.put("user.mobile", uphone);
            params.put("week.uid", "user.id");

        }
       // params.put(" a.create_at & > ", createStartAt);

        if (minWeekStartAt!=null) {
            params.put("week.start_at & > ", minWeekStartAt);

        }

        if (maxWeekStartAt!=null) {
            params.put("week.start_at & < ", maxWeekStartAt);

        }

        if (minWeekEndAt!=null) {
            params.put("week.end_at & > ", minWeekEndAt);

        }

        if (maxWeekEndAt!=null) {
            params.put("week.end_at & < ", maxWeekEndAt);

        }

        //senior
        if (seniorID!=null) {
            params.put("week.sid", seniorID);

        }

        if (StringUtils.isNotBlank(seniorNick)) {
            tables.add("user");
            params.put("user.nick & like ", "'%" + seniorNick + "%'");
            params.put("week.sid", "user.id");

        }

        if (StringUtils.isNotBlank(seniorPhone)) {
            tables.add("user");
            params.put("user.mobile", seniorPhone);
            params.put("week.sid", "user.id");

        }

        //head

        if (headID!=null) {
            params.put("week.hid", headID);

        }

        if (StringUtils.isNotBlank(headNick)) {
            tables.add("user");
            params.put("user.nick & like ", "'%" + headNick + "%'");
            params.put("week.hid", "user.id");

        }

        if (StringUtils.isNotBlank(headPhone)) {
            tables.add("user");
            params.put("user.mobile", headPhone);
            params.put("week.hid", "user.id");

        }

        //symptom
        if (sid!=null) {
            params.put("week.sid", sid);
        }
        if (StringUtils.isNotBlank(sname)) {
            tables.add("symptom");
            params.put("symptom.name & like ", "'%" + sname + "%'");
            params.put("week.sid", "symptom.id");

        }

        //symptomType
        if (tid!=null) {
            tables.add("stype");
            tables.add("symptom");
            params.put("stype.id", tid);
            params.put("symptom.tid", "stype.id");
            params.put("week.sid", "symptom.id");
        }

        if (StringUtils.isNotBlank(tname)) {
            tables.add("stype");
            tables.add("symptom");
            params.put("stype.name & like ", "'%" + tname + "%'");
            params.put("symptom.tid", "stype.id");
            params.put("week.sid", sid);
            params.put("week.sid", "symptom.id");

        }

        if (StringUtils.isNotBlank(sname)) {
            tables.add("symptom");
            params.put("symptom.name & like ", "'%" + sname + "%'");
            params.put("week.sid", "symptom.id");

        }



        if (count) {
            params.put("@query", "count(week.id)");
        } else {
            params.put("@query", "week.id");
            params.put("@order", "week.create_at asc ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;

    }}
