package com.ptteng.common.skill.util;

import com.ptteng.common.dao.util.SQLUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReviewUtil {

     
    /**
     * @param rid     审核ID    
     * @param branchID     分院ID
     * @param uid     用户ID   
     * @param unick     用户昵称   
     * @param uphone     用户手机号   
     * @param occouptionID     职业ID  
     * @param minReviewStartAt     周开始时间
     * @param maxReviwStartAt     周结束时间   
     * @param reviewerID       师兄ID   
     * @param reviewerNick     师兄昵称  
     * @param reviewerPhone     师兄手机号  
     * @param type	1 复盘评审 2 真实项目评     
     * @param status  审核状态 -1 未通过 0 通过
     * @param count
     * @return
     */
    public static Map<String, Object> getDynamicParam(Long rid,Long branchID,Long uid,String unick,
                                                      String uphone,Long occouptionID,Long minReviewStartAt,Long maxReviwStartAt,Long reviewerID
                                                      ,String reviewerNick,String reviewerPhone,Integer type,Integer status,boolean count){


        Map<String, Object> params = new HashMap<>();

        Set<String> tables = new HashSet();
        tables.add("review");
        if (rid!=null) {

            params.put("review.id", rid);

        }
        if (branchID!=null) {
            tables.add("user");
            params.put("user.branch", branchID);
            params.put("review.uid", "user.id");

        }


        if (uid!=null) {
            params.put("review.uid", uid);

        }

        if (StringUtils.isNotBlank(unick)) {
            tables.add("user");
            params.put("user.nick & like ", "'%" + unick + "%'");
            params.put("review.uid", "user.id");

        }

        if (StringUtils.isNotBlank(uphone)) {
            tables.add("user");
            params.put("user.mobile", uphone);
            params.put("review.uid", "user.id");

        }

        if (occouptionID!=null) {
            tables.add("user");
            params.put("user.oid", occouptionID);
            params.put("review.uid", "user.id");

        }


        if (StringUtils.isNotBlank(uphone)) {
            tables.add("user");
            params.put("user.mobile", uphone);
            params.put("review.uid", "user.id");

        }
        if (StringUtils.isNotBlank(uphone)) {
            tables.add("user");
            params.put("user.mobile", uphone);
            params.put("review.uid", "user.id");

        }
       // params.put(" a.create_at & > ", createStartAt);

        if (minReviewStartAt!=null) {
            params.put("review.start_at & > ", minReviewStartAt);

        }

        if (maxReviwStartAt!=null) {
            params.put("review.start_at & < ", maxReviwStartAt);

        }

        
        //senior
        if (reviewerID!=null) {
            params.put("review.rid", reviewerID);

        }

        if (StringUtils.isNotBlank(reviewerNick)) {
            tables.add("user");
            params.put("user.nick & like ", "'%" + reviewerNick + "%'");
            params.put("review.sid", "user.id");

        }

        if (StringUtils.isNotBlank(reviewerPhone)) {
            tables.add("user");
            params.put("user.mobile", reviewerPhone);
            params.put("review.sid", "user.id");

        }

    

        

        //type
        if (type!=null) {
            params.put("review.type", type);
        }
        
        //status
        if (status!=null) {
            params.put("review.status", status);
        }



        if (count) {
            params.put("@query", "count(review.id)");
        } else {
            params.put("@query", "review.id");
            params.put("@order", "review.create_at asc ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;

    }}
