package com.ptteng.common.skill.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.common.skill.model.Document;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface DocumentService extends BaseDaoService {


    public Long insert(Document document) throws ServiceException, ServiceDaoException;


    public List<Document> insertList(List<Document> documentList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Document document) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Document> documentList) throws ServiceException, ServiceDaoException;


    public Document getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Document> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDocumentIdBySid(Long sid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDocumentIdByOidAndType(Long oid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDocumentIdByOidAndType(Long oid, Integer type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDocumentIdBySidAndType(Long sid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDocumentIdBySidAndType(Long sid, Integer type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDocumentIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDocumentIdsByType(Integer type, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDocumentIds() throws ServiceException, ServiceDaoException;


}

