package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "message")
public class Message implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5074540398389866496L;

    /**
     * 类型  type
     * daily：评论回复
     * teacher：师兄弟关系 （前台展示到班级变更里面了）
     * classes：班级变更
     * task：任务审核
     * score：积分变动
     * notify：私信通知
     * card ：优惠卡券
     * collection ：收藏（前台未展示）
     * like：点赞（前台未展示）
     * private：私信内容
     * question：问答通知
     * record: 个人档案（22期新增）
     * school:校园（24期新增）
     * smallClass:小课堂（25期新增）
     * joinSchool: 加入校园（24期新增，不用在前台展示，后端统计校园日报用）
     * quitSchool: 退出校园（24期新增，不用在前台展示，后端统计校园日报用）
     * 欢迎加入修真院校园社区！  学员加入校园社区的消息内容
     * 您已退出修真院校园社区。  学员退出校园社区的消息内容
     */

    public static final String RECEIVE_TYPE = "receive";
    public static final String SEND_TYPE = "send";

    public static final String DAILY_TYPE = "daily";
    public static final String TEACHER_TYPE = "teacher";
    public static final String CLASS_TYPE = "classes";
    public static final String TASK_TYPE = "task";
    public static final String SCORE_TYPE = "score";
    public static final String NOTIFY_TYPE = "notify";
    public static final String CARD_TYPE = "card";
    public static final String COLLECTION_TYPE = "collection";
    public static final String LIKE_TYPE = "like";
    public static final String PRIVATE_TYPE = "private";
    public static final String QUESTION_TYPE = "question";
    public static final String RECORD_TYPE = "record";
    public static final String SCHOOL_TYPE = "school";
    public static final String CLASSES_TYPE = "smallClass";//小课堂


    /**
     * 用户每日发送私信限制
     */
    public static final String Type_privateCount = "message";


    /**
     * 用户每日发送私信限制
     */
    public static final String Name_privateMessageCount = "privateMessageCount";

    /**
     * 消息读取类型  0 已读 1 未读
     */
    public static final Integer Status_read = 0;
    public static final Integer Status_Unread = 1;

    /**
     * 消息模板  默认-1 无模板
     * 其他命名原则：24期之前，统一用10开头，24期及之后，用期数开头；之前约定过的不做修改
     *
     * 1 [北京分院|内门弟子]UI-圈儿 赞了 交互设计的原则有哪些？中的你回答
     * 2 [北京分院|内门弟子]UI-圈儿 回答了你提出的 交互设计的原则有哪些？
     * 3 你在 交互设计的原则有哪些？中的回答已被隐藏
     * 4 你提出的 交互设计的原则有哪些 已被收录
     * 5 你提出的 交互设计的原则有哪些 已被隐藏
     * 106 您已成功加入online-js-68班
     * 107 你提交的档案表被驳回，请查看原因并重新填写提交
     * 108 新学员 锦毛虎 无师兄可分配，请在后台手动指定师兄
     * 109 这位同学，由于长时间未写日报，你已被分配至僵尸集中营，请退出班级后重新加入班级，即可再次获得师兄，加油~
     * 110 管理员指派 123 担任您的师兄
     * 111 解除了 123张帆 与您的师兄弟关系
     * 112 您 2018-03-10的日报 已被 [真传弟子] -阮少楠 评论
     * 113 [无名弟子] 病尉遅 回复了你对 《修真院弟子【16446】 | 2017年09月05号的日报》 的评论
     * 114 您得到了积分奖励，点击查看
     * 115 管理员指派 内门-java-24 成为您的师弟
     * 116 admin解除了 123张帆 与您的师兄弟关系
     * 117 123 给你发送了一条私信
     * 118 欢迎加入修真院！我是你的师兄123张帆，如果在学习过程中遇到任何问题，欢迎私信m我~
     * 119 欢迎加入修真院！我是你的师姐124古尘，如果在学习过程中遇到任何问题，欢迎私信m我~
     * 120 559师弟 提交了 Android的任务10
     * 121 559师兄已拒绝了 你的Android任务10
     * 122 559师兄已通过了 你的Android任务10
     * 123 欢迎来到IT修真院，IT新人请去 职业殿堂了解互联网职业，若想深入了解每个职业学习难度、发展趋势，可参与互联网职业介绍 赶紧选择职业，领取任务，踏上IT修真之旅吧！
     * 124 亲爱的，欢迎您选择加入修真院，我是修真院的守关大师，关于修真院学习的一切问题都可以找我咨询。同时，为了感谢您的
     * 英明选择，我们特地从注册用户中选择了颜值最高的几个人，随机赠送职业规划VIP服务，一对一职业规划，帮助你更好的做出选择，
     * 有意请加我微信 it_xzy（备注职业规划）祝您在修真院有一个新的开始，400多已经转行成功的师兄们提前恭祝您马到成功~ O(∩_∩)O~
     * 125 您申请使用了一张 年会1800元[2018020820001943]
     * 126 用户锦毛虎 申请使用了一张年会1800元[2018020820001943]，请进入后台审核
     * 127 您给锦毛虎转让了一张年会1800元[2018020820001943]
     * 128 锦毛虎给您转让了一张年会1800元[2018020820001943]
     * 129 您的积分已消费，点击查看
     * 130 管理员给您发放了一张年会1800元[2018020820001943]
     * 131 您的年会1800元[2018020820001943]已审核通过并生效
     * 132 您的年会1800元[2018020820001943]已审核拒绝，拒绝理由是：你不够帅
     * 133 您2017-08-08购买的服务器已发货,点击查看
     */
    public static final Integer TEMPLATE_NONE = -1;
    public static final Integer TEMPLATE_1 = 1;
    public static final Integer TEMPLATE_2 = 2;
    public static final Integer TEMPLATE_3 = 3;
    public static final Integer TEMPLATE_4 = 4;
    public static final Integer TEMPLATE_5 = 5;//小课堂
    public static final Integer TEMPLATE_SMALLCLASS = 6;
    public static final Integer TEMPLATE_106 = 106;
    public static final Integer TEMPLATE_107 = 107;
    public static final Integer TEMPLATE_108 = 108;
    public static final Integer TEMPLATE_109 = 109;
    public static final Integer TEMPLATE_110 = 110;
    public static final Integer TEMPLATE_111 = 111;
    public static final Integer TEMPLATE_112 = 112;
    public static final Integer TEMPLATE_113 = 113;
    public static final Integer TEMPLATE_114 = 114;
    public static final Integer TEMPLATE_115 = 115;
    public static final Integer TEMPLATE_116 = 116;
    public static final Integer TEMPLATE_117 = 117;
    public static final Integer TEMPLATE_118 = 118;
    public static final Integer TEMPLATE_119 = 119;
    public static final Integer TEMPLATE_120 = 120;
    public static final Integer TEMPLATE_121 = 121;
    public static final Integer TEMPLATE_122 = 122;
    public static final Integer TEMPLATE_123 = 123;
    public static final Integer TEMPLATE_124 = 124;
    public static final Integer TEMPLATE_125 = 125;
    public static final Integer TEMPLATE_126 = 126;
    public static final Integer TEMPLATE_127 = 127;
    public static final Integer TEMPLATE_128 = 128;
    public static final Integer TEMPLATE_129 = 129;
    public static final Integer TEMPLATE_130 = 130;
    public static final Integer TEMPLATE_131 = 131;
    public static final Integer TEMPLATE_132 = 132;
    public static final Integer TEMPLATE_133 = 133;

    /**
     * school（24期校园社区）
     * 欢迎加入修真院校园社区！
     * 您已退出修真院校园社区。
     */
    public static final Integer SCHOOL_TEMPLATE_1 = 241;
    public static final Integer SCHOOL_TEMPLATE_2 = 242;
    /**
     * smallClass（25期小课堂）
     * 251 您2018-03-17的小课堂将在七天后开始！
     * 252 您未参加2018-03-17  20：00: 00的小课堂，点击查看可重新进入学习！
     * 253 您未参加2018-03-17  20：00: 00的小课堂，相应积分已被扣除，点击查看可重新进入学习！
     * 254 您已经加入小课堂pm  A组，点击查看课表
     * 255 您已经从小课堂pm  A组移除
     * 256 您2018-03-09的小课堂已被[北京分院丨真传弟子]PM-毛雨星评论
     * 257 [武汉分院丨内门弟子]PM-刘宁回复了你对《修真院弟子【21842】丨2018年03月09号的小课堂》的评论
     * 258 559师弟 提交了 Android 2018-07-17的小课堂
     */
    public static final Integer SMALL_CLASS_TEMPLATE_251 = 251;
    public static final Integer SMALL_CLASS_TEMPLATE_252 = 252;
    public static final Integer SMALL_CLASS_TEMPLATE_253 = 253;
    public static final Integer SMALL_CLASS_TEMPLATE_254 = 254;
    public static final Integer SMALL_CLASS_TEMPLATE_255 = 255;
    public static final Integer SMALL_CLASS_TEMPLATE_256 = 256;
    public static final Integer SMALL_CLASS_TEMPLATE_257 = 257;
    public static final Integer SMALL_CLASS_TEMPLATE_258 = 258;

    /*校园相关的消息内容*/
    public static final String JOIN_SCHOOL = "joinSchool";
    public static final String QUIT_SCHOOL = "quitSchool";
    public static final String JOIN_MSG = "欢迎加入修真院校园社区！";
    public static final String QUIT_MSG = "您已退出修真院校园社区。";

    /**
     * message的content中json字符串的key
     * uid:用户id
     * uNick:用户昵称
     * aUid:管理员id
     * aNick:管理员昵称
     * sUid:学生id
     * sNick:学生昵称
     * tUid：老师id
     * tNick：老师昵称
     * managerId：管理员id
     * managerName：管理员姓名
     * students：学生信息的集合
     * time：时间
     * studyNum：学号
     * oName：职业名称
     * tNum：任务名称
     * cTitle：卡券名称
     * cCode：卡券码
     * messageId：消息id
     * refuseReason：卡券申请被驳回的理由
     * authorUid：日报（晨报）或小课堂的作者
     */
    public static final String KEY_UID = "uid";
    public static final String KEY_USER_NICK = "uNick";
    public static final String KEY_ADMIN_UID = "aUid";
    public static final String KEY_ADMIN_NICK = "aNick";
    public static final String KEY_SUID = "sUid";
    public static final String KEY_SNICK= "sNick";
    public static final String KEY_TUID = "tUid";
    public static final String KEY_TNICK = "tNick";
    public static final String KEY_MID = "managerId";
    public static final String KEY_MNAME = "managerName";
    public static final String KEY_STUDENTS = "students";
    public static final String KEY_TIME = "time";
    public static final String KEY_STUDY_NUM = "studyNum";
    public static final String KEY_ONAME = "oName";
    public static final String KEY_TASK_NUM = "tNum";
    public static final String KEY_CARD_TITLE = "cTitle";
    public static final String KEY_CARD_CODE = "cCode";
    public static final String KEY_MESSAGE_ID = "messageId";
    public static final String KEY_REFUSE_REASON = "refuseReason";
    public static final String KEY_AUTHOR_UID = "authorUid";


    /**
     * 私信状态： 0 删除 1 正常 2 私信发送人删除  3 私信接收人删除   4 双方都删除
     */

    public static final Integer STATUS_DELETE = 0;
    public static final Integer STATUS_UNDELETE = 1;
    public static final Integer STATUS_SENDDELETE = 2;
    public static final Integer STATUS_RECEIVEDELETE = 3;
    public static final Integer STATUS_ALLDELETE = 4;


    public static final int Oid_None = -1;


    private Long id;

    private Long sendId = 0L;


    private Long receiveId = 0L;


    private String sendName = "admin";


    private String receiveName;


    private String content;


    private Integer status = STATUS_UNDELETE;


    private Integer unread = Status_Unread;


    private String type;

    /*
     * 消息模板
     */
    private Integer template = TEMPLATE_NONE;


    private Long relationId;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    private Long updateAt = 0L;


    private Long createAt = 0L;


    private Integer unreadCount = 0;

    //消息未读数
    @Transient
    public Integer getunreadCount() {
        return unreadCount;
    }

    public void setunreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
    }

    public Message() {
    }

    public Message(Long receiveId, String receiveName, String type, Long relationId) {
        this.receiveId = receiveId;
        this.receiveName = receiveName;
        this.type = type;
        this.relationId = relationId;
    }

    public Message(Long receiveId, String receiveName, String content, String type, Long relationId) {
        this.receiveId = receiveId;
        this.receiveName = receiveName;
        this.content = content;
        this.type = type;
        this.relationId = relationId;
    }


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "send_id")
    public Long getSendId() {
        return sendId;
    }


    public void setSendId(Long sendId) {
        this.sendId = sendId;
    }

    @Column(name = "receive_id")
    public Long getReceiveId() {
        return receiveId;
    }


    public void setReceiveId(Long receiveId) {
        this.receiveId = receiveId;
    }

    @Column(name = "send_name")
    public String getSendName() {
        return sendName;
    }


    public void setSendName(String sendName) {
        this.sendName = sendName;
    }

    @Column(name = "receive_name")
    public String getReceiveName() {
        return receiveName;
    }


    public void setReceiveName(String receiveName) {
        this.receiveName = receiveName;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "unread")
    public Integer getUnread() {
        return unread;
    }

    public void setUnread(Integer unread) {
        this.unread = unread;
    }

    @Column(name = "type")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name = "template")
    public Integer getTemplate() {
        return template;
    }

    public void setTemplate(Integer template) {
        this.template = template;
    }

    @Column(name = "relation_id")
    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

