package com.ptteng.common.skill.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.common.skill.model.ClassSubject;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ClassSubjectService extends BaseDaoService {


    public Long insert(ClassSubject classSubject) throws ServiceException, ServiceDaoException;


    public List<ClassSubject> insertList(List<ClassSubject> classSubjectList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(ClassSubject classSubject) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<ClassSubject> classSubjectList) throws ServiceException, ServiceDaoException;


    public ClassSubject getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<ClassSubject> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getClassSubjectIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countClassSubjectIds() throws ServiceException, ServiceDaoException;


}

