package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "comment")
public class Comment implements Serializable {

    private static final long serialVersionUID = 6492162146795447296L;

    /*
    * 评论类型：0：默认值，也代表日报/晨报
    * 10：日报/晨报
    * 20：小课堂
    * */
    public static final int TYPE_DAILY_DEFAULT = 0;
    public static final int TYPE_DAILY = 10;
    public static final int TYPE_CLASS = 20;


    private Long id;


    private Long uid;

    //回复@用户id
    private Long atUid;

    private Long oid;
    private Long cid;
    private Long num;



    private Long did;


    private String comment;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    private int type;



    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "at_uid")
    public Long getAtUid() {
        return atUid;
    }


    public void setAtUid(Long atUid) {
        this.atUid = atUid;
    }

    @Column(name = "did")
    public Long getDid() {
        return did;
    }


    public void setDid(Long did) {
        this.did = did;
    }

    @Column(name = "comment")
    public String getComment() {
        return comment;
    }


    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }



    @Column(name = "oid")
    public Long getOid() {
        return oid;
    }
    public void setOid(Long oid) {
        this.oid = oid;
    }

    @Column(name = "cid")
    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    @Column(name = "num")
    public Long getNum() {
        return num;
    }

    public void setNum(Long num) {
        this.num = num;
    }

    @Column(name = "type")
    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

