package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "class_timetable")
public class ClassTimetable implements Serializable {


    private static final long serialVersionUID = 5160336492818302976L;

    /**
     * publishState 课堂发布状态：1 未发布  2 已发布
     */
    public static final int NOT_PUBLISHED = 1;
    public static final int PUBLISHED = 2;

    /**
     * speakStatus 课堂状态：1：预告 2：未审核 3：未评级 4：已评级
     */
    public static final int APPOINT_NOT_PUBLISH = 1;
    public static final int APPOINT_PUBLISHED = 2;
    public static final int NO_LEVEL = 3;
    public static final int HAS_LEVEL = 4;

    /**
     * status 上下架(精选)状态 0：下架 1：上架 2：课表被删除后的状态（课表删除后，不影响小课堂的展示）
     * 3:深度思考删除后，小课堂也被假删除的状态
     */
    public static final int OFF_SHELF = 0;
    public static final int ON_SHELF = 1;
    public static final int TIMETABLE_DELETED = 2;
    public static final int THINK_DELETED = 3;

    /**
     * 小课堂评级 1：下品 2：中品 3：上品
     */
    public static final int LOW_LEVEL = 1;
    public static final int MIDDLE_LEVEL = 2;
    public static final int HIGH_LEVEL = 3;

    /**
     * 获取那种类型的数据："timetable"：获取课表   "classes"：获取小课堂
     */
    public static final String TYPE_TIMETABLE = "timetable";
    public static final String TYPE_CLASSES= "classes";

    private Long id;


    private Long arrangeDate;


    private Long subjectId;


    private Long classTeamId;


    private Long teachUid;


    //课堂发布状态：1：未发布  2：已发布
    private int publishState;


    //课程状态 1：预告 2：未审核 3：未评级 4：已评级
    private int speakStatus;


    private int level;


    private String comment;


    //上下架(精选)状态 0：下架 1：上架 2：深度思考删除后，小课堂也被假删除的状态
    private int status;


    private String leaveUid;


    private String absentUid;


    private int groupUserCount;


    private int collection;


    private int love;


    private int readCount;


    private int commentCount;


    private String pptUrl;


    private String videoUrl;


    private String content;


    private String targetPeople;


    private String extect;


    private String classAbstract;


    private String previewImg;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "arrange_date")
    public Long getArrangeDate() {
        return arrangeDate;
    }


    public void setArrangeDate(Long arrangeDate) {
        this.arrangeDate = arrangeDate;
    }

    @Column(name = "subject_id")
    public Long getSubjectId() {
        return subjectId;
    }


    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }


    @Column(name = "class_team_id")
    public Long getClassTeamId() {
        return classTeamId;
    }


    public void setClassTeamId(Long classTeamId) {
        this.classTeamId = classTeamId;
    }


    @Column(name = "teach_uid")
    public Long getTeachUid() {
        return teachUid;
    }


    public void setTeachUid(Long teachUid) {
        this.teachUid = teachUid;
    }


    @Column(name = "publish_state")
    public int getPublishState() {
        return publishState;
    }

    public void setPublishState(int publishState) {
        this.publishState = publishState;
    }


    @Column(name = "speak_status")
    public int getSpeakStatus() {
        return speakStatus;
    }


    public void setSpeakStatus(int speakStatus) {
        this.speakStatus = speakStatus;
    }

    @Column(name = "level")
    public int getLevel() {
        return level;
    }


    public void setLevel(int level) {
        this.level = level;
    }

    @Column(name = "comment")
    public String getComment() {
        return comment;
    }


    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name = "status")
    public int getStatus() {
        return status;
    }


    public void setStatus(int status) {
        this.status = status;
    }

    @Column(name = "leave_uid")
    public String getLeaveUid() {
        return leaveUid;
    }


    public void setLeaveUid(String leaveUid) {
        this.leaveUid = leaveUid;
    }

    @Column(name = "absent_uid")
    public String getAbsentUid() {
        return absentUid;
    }


    public void setAbsentUid(String absentUid) {
        this.absentUid = absentUid;
    }


    @Column(name = "group_user_count")
    public int getGroupUserCount() {
        return groupUserCount;
    }


    public void setGroupUserCount(int groupUserCount) {
        this.groupUserCount = groupUserCount;
    }

    @Column(name = "collection")
    public int getCollection() {
        return collection;
    }


    public void setCollection(int collection) {
        this.collection = collection;
    }

    @Column(name = "love")
    public int getLove() {
        return love;
    }


    public void setLove(int love) {
        this.love = love;
    }

    @Column(name = "read_count")
    public int getReadCount() {
        return readCount;
    }


    public void setCommentCount(int commentCount) {
        this.commentCount = commentCount;
    }


    @Column(name = "comment_count")
    public int getCommentCount() {
        return commentCount;
    }


    public void setReadCount(int readCount) {
        this.readCount = readCount;
    }

    @Column(name = "ppt_url")
    public String getPptUrl() {
        return pptUrl;
    }


    public void setPptUrl(String pptUrl) {
        this.pptUrl = pptUrl;
    }

    @Column(name = "video_url")
    public String getVideoUrl() {
        return videoUrl;
    }


    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "target_people")
    public String getTargetPeople() {
        return targetPeople;
    }


    public void setTargetPeople(String targetPeople) {
        this.targetPeople = targetPeople;
    }

    @Column(name = "expect")
    public String getExtect() {
        return extect;
    }


    public void setExtect(String extect) {
        this.extect = extect;
    }

    @Column(name = "class_abstract")
    public String getClassAbstract() {
        return classAbstract;
    }


    public void setClassAbstract(String classAbstract) {
        this.classAbstract = classAbstract;
    }

    @Column(name = "preview_img")
    public String getPreviewImg() {
        return previewImg;
    }


    public void setPreviewImg(String previewImg) {
        this.previewImg = previewImg;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

