/**
 *
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.skill.model.Article;
import com.ptteng.common.skill.service.ArticleService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ArticleSCAClient implements ArticleService {

    private ArticleService articleService;

    public ArticleService getArticleService() {
        return articleService;
    }


    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }


    @Override
    public Long insert(Article article) throws ServiceException, ServiceDaoException {

        return articleService.insert(article);


    }


    @Override
    public List<Article> insertList(List<Article> articleList) throws ServiceException, ServiceDaoException {

        return articleService.insertList(articleList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return articleService.delete(id);


    }


    @Override
    public boolean update(Article article) throws ServiceException, ServiceDaoException {

        return articleService.update(article);


    }


    @Override
    public boolean updateList(List<Article> articleList) throws ServiceException, ServiceDaoException {

        return articleService.updateList(articleList);


    }


    @Override
    public Article getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return articleService.getObjectById(id);


    }


    @Override
    public List<Article> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return articleService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getArticleIdsByCidAndType(Long cid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return articleService.getArticleIdsByCidAndType(cid, type, start, limit);


    }

    @Override
    public List<Long> getArticleIdsByUidAndType(Long uid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return articleService.getArticleIdsByUidAndType(uid,type,start,limit);
    }

    @Override
    public Integer counttArticleIdsByUidAndType(Long uid, String type) throws ServiceException, ServiceDaoException {
        return articleService.counttArticleIdsByUidAndType(uid,type);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countArticleIdsByCidAndType(Long cid, String type) throws ServiceException, ServiceDaoException {

        return articleService.countArticleIdsByCidAndType(cid, type);


    }


    @Override
    public List<Long> getArticleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return articleService.getArticleIds(start, limit);
    }

    @Override
    public Integer countArticleIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return articleService.countArticleIds();
    }

    @Override
    public Long getLastArticleIdByUidAndCid(Long uid, Long cid) throws ServiceException, ServiceDaoException {
        return articleService.getLastArticleIdByUidAndCid(uid, cid);
    }

    @Override
    public List<Long> getArticleIdByUidAndCid(Long uid, Long cid,Integer start,Integer limit) throws ServiceException, ServiceDaoException {
        return articleService.getArticleIdByUidAndCid(uid, cid, start, limit);
    }

    @Override
    public List<Long> getArticleIdsByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return articleService.getArticleIdsByOidAndType(oid, type, start, limit);
    }

    @Override
    public Integer countArticleIdsByOidAndType(Long oid, String type) throws ServiceException, ServiceDaoException {
        return articleService.countArticleIdsByOidAndType(oid, type);
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return articleService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return articleService.getObjectByDynamicCondition(aClass, map, integer, integer1);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return articleService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        articleService.deleteList(clz, ids);

    }


}

