package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "user_article_relation")
public class UserArticleRelation implements Serializable{

	/*
	 * 
	 */
	private static final long serialVersionUID = 5442797991801696256L;
	/*
	 * 排序方式	 * 1-点赞数	 2-收藏数	 3-日报创建时间	 4-评论数	 5-查看数
	 */
	public static final int LOVE=1;
	public static final int COLLECTION=2;
	public static final int ARTICLE_CREATE_AT=3;
	public static final int COMMENT =4;
	public static final int READ =5;

	/*
     * target_type 类型  1 日报-daily  2 文档-document  3 视频-video  4  问题-question  5 回答-answer
     */
	public static final Integer TARGET_DAILY = 1;
	public static final Integer TARGET_DOCUMENT = 2;
	public static final Integer TARGET_VIDEO = 3;
	public static final Integer TARGET_QUESTION = 4;
	public static final Integer TARGET_ANSWER = 5;

	/*
    * action 动作  点赞/收藏-love  取消点赞/收藏-dislike
    */
	public static final String ACTION_LOVE = "love";
	public static final String  ACTION_DISLIKE = "dislike";

	/**
	 * 顺序 	 0-逆序	 1-正序
	 */
	public static final int DESC=0;
	public static final int ASC=1;

	/**
	 * type  1-点赞 	 2-收藏
	 */
	public static final int STATUS_LOVE = 1;
	public static final int STATUS_COLLECTION = 2;


	/**
	 * listType  1-用户点赞 	 2-用户创建
	 */
	public static final int LIST_TYPE_LOVE = 1;
	public static final int LIST_TYPE_CREATE = 2;

	/**
	 * whether  1-存在 2-撤销
	 */
	public static final int WHETHER_VALID = 1;
	public static final int WHETHER_INVALID = 2;
	
	/**
	 * 用户日报分数  上品-9 中品-3 下品-1
	 */
    public static final int TOP_ARTICLE_SCORE = 9;
    public static final int MIDDLE_ARTICLE_SCORE = 3;
    public static final int LOWER_ARTICLE_SCORE = 1;
    private  Long id;
	
  	 
    private  Long aid;
	
  	 
    private  Long uid;


	
  	 /**
  	 * 用户与日报关系 1-点赞 2-收藏
  	 */
    private  Integer type;


	//默认类型为日报
	private Integer targetType = TARGET_DAILY;


    private  Integer whether;
	
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "aid")
	public Long getAid() {
		return aid;
	}
	
	
	public void setAid(Long aid) {
		this.aid = aid;
	}
		 	@Column(name = "uid")
	public Long getUid() {
		return uid;
	}
	
	
	public void setUid(Long uid) {
		this.uid = uid;
	}
		 	@Column(name = "type")
	public Integer getType() {
		return type;
	}

	@Column(name = "target_type")
	public Integer getTargetType() {
		return targetType;
	}


	public void setTargetType(Integer targetType) {
		this.targetType = targetType;
	}
	
	public void setType(Integer type) {
		this.type = type;
	}
		 	@Column(name = "whether")
	public Integer getWhether() {
		return whether;
	}
	
	
	public void setWhether(Integer whether) {
		this.whether = whether;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

