/**
 * 
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.skill.model.Iteration;
import com.ptteng.common.skill.service.IterationService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class IterationSCAClient implements IterationService {

    private IterationService iterationService;

	public IterationService getIterationService() {
		return iterationService;
	}
	
	
	public void setIterationService(IterationService iterationService) {
		this.iterationService =iterationService;
	}
	
	
			   
		@Override
		public Long insert(Iteration iteration)throws ServiceException, ServiceDaoException{
		
		return iterationService.insert(iteration);
		          
		
		}	
		  
    	   
		@Override
		public List<Iteration> insertList(List<Iteration> iterationList)throws ServiceException, ServiceDaoException{
		
		return iterationService.insertList(iterationList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return iterationService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Iteration iteration)throws ServiceException, ServiceDaoException{
		
		return iterationService.update(iteration);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Iteration> iterationList)throws ServiceException, ServiceDaoException{
		
		return iterationService.updateList(iterationList);
		          
		
		}	
		  
    	   
		@Override
		public Iteration getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return iterationService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Iteration> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return iterationService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIterationIdsByProductIdAndStatusOrderBySort(Long productId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return iterationService.getIterationIdsByProductIdAndStatusOrderBySort(productId,status,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIterationIdsByNameOrderBySort(String name,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return iterationService.getIterationIdsByNameOrderBySort(name,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIterationIdsByProductIdAndStatusOrderBySort(Long productId,Integer status)throws ServiceException, ServiceDaoException{
		
		return iterationService.countIterationIdsByProductIdAndStatusOrderBySort(productId,status);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIterationIdsByNameOrderBySort(String name)throws ServiceException, ServiceDaoException{
		
		return iterationService.countIterationIdsByNameOrderBySort(name);
	
	
	}
	
		
	
		@Override
	public List<Long> getIterationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return iterationService.getIterationIds(start, limit);
	}

	@Override
	public Integer countIterationIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return iterationService.countIterationIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return iterationService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return iterationService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   iterationService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.iterationService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

