package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "school")
public class School implements Serializable {

    private static final long serialVersionUID = 2403872713498906624L;

    public static final Integer SCHOOL_TYPE_985 = 1; //985
    public static final Integer SCHOOL_TYPE_211 = 2; //211
    public static final Integer SCHOOL_TYPE_NORMAL = 3; //非重点院校

    private Long id;

    private String name;

    private Integer schoolType;

    private String province;

    private String type;

    private String properties;

    private Long createBy;

    private Long updateBy;

    private Long updateAt;

    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "province")
    public String getProvince() {
        return province;
    }


    public void setProvince(String province) {
        this.province = province;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    @Column(name = "school_type")
    public Integer getSchoolType() {
        return schoolType;
    }

    public void setSchoolType(Integer schoolType) {
        this.schoolType = schoolType;
    }

    @Column(name = "type")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name = "properties")
    public String getProperties() {
        return properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

