package com.ptteng.common.skill.service;

import com.ptteng.common.skill.model.InDoorStudentStatistics;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

/**
 * Created by J.w on 2018/3/23.
 * 功能描述：
 */
@Remotable
public interface TemplateTestService {

    //校正所有未读消息为负数的情况
    void updateIsLookNumber();

    //22期 - 档案管理 - 按条件展示折线图
    List<InDoorStudentStatistics> getLineChartByParams(String school, String place, String major, Integer grade, Integer occupationId, Integer age, Long minStartAt, Long maxStartAt);

    //22期 - 档案管理 - 按条件展示饼图
    List<InDoorStudentStatistics> getPieCharByParams(Long minPassAt, Long maxPassAt, Integer occupationId, Integer condition);

    //22期 - 档案管理 - 根据档案状态计算档案总数
    Integer getRecordTotalNumber(Integer status);

    //22期 - 档案管理 - 根据省名称查省编号
    Long getProvinceIdByProvince(String province);

    //22期 - 档案管理 - 根据城市名称查城市编号
    Long getCityIdByCity(String city);

    //22期 - 档案管理 - 根据区县名称查区县编号
    Long getCountyIdByCounty(String county);
}
