package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "question")
public class Question implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4941524014863572992L;	
	
		
	/**
	 * type 任务类型
	 * 0  环境配置/工具操作
	 * 1 代码/设计错误
	 */
	public static final Integer TYPE_IDE = 0;
	public static final Integer TYPE_CODE = 1;
    	
	/**
	 * orderBy 排序
	 * 1 踩坑数排序
	 * 2 回答数排序
	 * 3 创建时间排序
	 * 4 修改时间排序
	 * 
	 */
	public static final Integer ORDER_BY_AGREE_COUNT = 1;
	public static final Integer ORDER_BY_ANSWER_COUNT = 2;
	public static final Integer ORDER_BY_CREATE_AT = 3;
	public static final Integer ORDER_BY_UPDATE_AT = 4;
    	
	/**
	 * adopt 收录
	 * 0 未收录
	 * 1 已收录
	 */
	public static final Integer ADOPT_OUT = 0;
	public static final Integer ADOPT_IN = 1;


	/**
	 * isAgree 收录
	 * 0 未收录
	 * 1 已收录
	 */
	public static final Integer IS_AGREE_FALSE = 0;
	public static final Integer IS_AGREE_TRUE = 1;
    	
   	 
    private  Long id;
	
  	 
    private  Long oid;
	
  	 
    private  Long tid;
	
  	 
    private  Integer type;
	
  	 
    private  String title;
	
  	 
    private  String description;
	
  	 
    private  String modules;
	
	//问题默认展示
    private  Integer status=Constants.STATUS_SHOW;
	
	//问题默认不收录
    private  Integer adopt=ADOPT_OUT;
	
	//默认踩坑数0
    private  Integer agreeNum=0;
	
	//isAgree表示是否踩坑，临时字段，不存入数据库  0 否 1 是
	@Transient
    private  Integer isAgree=0;
	
	//默认回答数0
    private  Integer answerNum=0;
	
  	 
    private  Long createBy;
	
  	 
    private  Long createAt;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "oid")
	public Long getOid() {
		return oid;
	}
	
	
	public void setOid(Long oid) {
		this.oid = oid;
	}
		 	@Column(name = "tid")
	public Long getTid() {
		return tid;
	}
	
	
	public void setTid(Long tid) {
		this.tid = tid;
	}
		 	@Column(name = "type")
	public Integer getType() {
		return type;
	}
	
	
	public void setType(Integer type) {
		this.type = type;
	}
		 	@Column(name = "title")
	public String getTitle() {
		return title;
	}
	
	
	public void setTitle(String title) {
		this.title = title;
	}
		 	@Column(name = "description")
	public String getDescription() {
		return description;
	}
	
	
	public void setDescription(String description) {
		this.description = description;
	}
		 	@Column(name = "modules")
	public String getModules() {
		return modules;
	}
	
	
	public void setModules(String modules) {
		this.modules = modules;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "adopt")
	public Integer getAdopt() {
		return adopt;
	}
	
	
	public void setAdopt(Integer adopt) {
		this.adopt = adopt;
	}
		 	@Column(name = "agree_num")
	public Integer getAgreeNum() {
		return agreeNum;
	}

	@Transient
	public void setAgreeNum(Integer agreeNum) {
		this.agreeNum = agreeNum;
	}
	@Transient
	public Integer getIsAgree() {
		return isAgree;
	}
	
	
	public void setIsAgree(Integer isAgree) {
		this.isAgree = isAgree;
	}
		 	@Column(name = "answer_num")
	public Integer getAnswerNum() {
		return answerNum;
	}
	
	
	public void setAnswerNum(Integer answerNum) {
		this.answerNum = answerNum;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

