package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "card")
public class Card implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 9008038490687898624L;



    /**
     * 卡券状态常量 1-未发放
     */
    public static final int STATUS_UNISSUED = 1;
    /**
     * 卡券状态常量 2-已发放未使用
     */
    public static final int STATUS_ISSUED = 2;
    /**
     * 卡券状态常量 3-申请使用核销中
     */
    public static final int STATUS_VERIFICATING = 3;
    /**
     * 卡券状态常量 4-已核销
     */
    public static final int STATUS_VERIFICATED = 4;
    /**
     * 卡券状态常量 6-已转让
     */
    public static final int STATUS_CESSION = 6;
    /**
     * 卡券状态常量 7-过期
     */
    public static final int STATUS_EXPIRE = 7;



    /**
     * 卡券审核 0-不通过
     */
    public static final int VERIFICATION_OFF = 0;
    /**
     * 卡券审核 1-通过
     */
    public static final int VERIFICATION_ON = 1;



    /**
     * 0-禁用
     */
    public static final int CARD_VALID_DISABLE = 0;
    /**
     * 1-启用
     */
    public static final int CARD_VALID_ENABLE = 1;

    /**
     * 自增id
     */
    private Long id;

    /**
     * 卡券编码
     */
    private String code;

    /**
     * 卡券类型id
     */
    private Long tid;

    /**
     * 持有人id
     */
    private Long ownerId;

    /**
     * 发放人id
     */
    private Long assignId;

    /**
     * 核销人id
     */
    private Long verificationId;

    /**
     * 卡券状态
     */
    private Integer status;

    /**
     * 卡券启用禁用
     */
    private Integer cardValid;

    /**
     * 类型启用禁用
     */
    private Integer typeValid;

    /**
     * 发放时间
     */
    private Long assignAt;

    /**
     * 使用时间
     */
    private Long applyAt;

    /**
     * 核销时间
     */
    private Long verificationAt;

    /**
     * 过期时间
     */
    private Long expireAt;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }


    @Column(name = "code")
    public String getCode() {
        return code;
    }


    public void setCode(String code) {
        this.code = code;
    }

    @Column(name = "tid")
    public Long getTid() {
        return tid;
    }


    public void setTid(Long tid) {
        this.tid = tid;
    }

    @Column(name = "owner_id")
    public Long getOwnerId() {
        return ownerId;
    }


    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    @Column(name = "assign_id")
    public Long getAssignId() {
        return assignId;
    }


    public void setAssignId(Long assignId) {
        this.assignId = assignId;
    }

    @Column(name = "verification_id")
    public Long getVerificationId() {
        return verificationId;
    }


    public void setVerificationId(Long verificationId) {
        this.verificationId = verificationId;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "card_valid")
    public Integer getCardValid() {
        return cardValid;
    }

    public void setCardValid(Integer cardValid) {
        this.cardValid = cardValid;
    }

    @Column(name = "ctype_valid")
    public Integer getTypeValid() {
        return typeValid;
    }

    public void setTypeValid(Integer typeValid) {
        this.typeValid = typeValid;
    }


    @Column(name = "assign_at")
    public Long getAssignAt() {
        return assignAt;
    }


    public void setAssignAt(Long assignAt) {
        this.assignAt = assignAt;
    }

    @Column(name = "apply_at")
    public Long getApplyAt() {
        return applyAt;
    }


    public void setApplyAt(Long applyAt) {
        this.applyAt = applyAt;
    }

    @Column(name = "verification_at")
    public Long getVerificationAt() {
        return verificationAt;
    }


    public void setVerificationAt(Long verificationAt) {
        this.verificationAt = verificationAt;
    }

    @Column(name = "expire_at")
    public Long getExpireAt() {
        return expireAt;
    }


    public void setExpireAt(Long expireAt) {
        this.expireAt = expireAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

