package com.ptteng.common.skill.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "message")
public class Message implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5074540398389866496L;

    /**
     * 类型  type
     * daily：评论回复
     * teacher：师兄弟关系 （前台展示到班级变更里面了）
     * classes：班级变更
     * task：任务审核
     * score：积分变动
     * notify：私信通知
     * card ：优惠卡券
     * collection ：收藏（前台未展示）
     * like：点赞（前台未展示）
     * private：私信内容
     * question：问答通知
     * record: 个人档案（22期新增）
     */

    public static final String RECEIVE_TYPE = "receive";
    public static final String SEND_TYPE = "send";

    public static final String DAILY_TYPE = "daily";
    public static final String TEACHER_TYPE = "teacher";
    public static final String CLASS_TYPE = "classes";
    public static final String TASK_TYPE = "task";
    public static final String SCORE_TYPE = "score";
    public static final String NOTIFY_TYPE = "notify";
    public static final String CARD_TYPE = "card";
    public static final String COLLECTION_TYPE = "collection";
    public static final String LIKE_TYPE = "like";
    public static final String PRIVATE_TYPE = "private";
    public static final String QUESTION_TYPE = "question";
    public static final String RECORD_TYPE = "record";


    /**
     * 用户每日发送私信限制
     */
    public static final String Type_privateCount = "message";


    /**
     * 用户每日发送私信限制
     */
    public static final String Name_privateMessageCount = "privateMessageCount";

    /**
     * 消息读取类型  0 已读 1 未读
     */
    public static final Integer Status_read = 0;
    public static final Integer Status_Unread = 1;

    /**
     * 消息模板  默认-1 无模板
     * question
     * 1 [北京分院|内门弟子]UI-圈儿 赞了 交互设计的原则有哪些？中的你回答
     * 2 [北京分院|内门弟子]UI-圈儿 回答了你提出的 交互设计的原则有哪些？
     * 3 你在 交互设计的原则有哪些？中的回答已被隐藏
     * 4 你提出的 交互设计的原则有哪些 已被收录
     * 5 你提出的 交互设计的原则有哪些 已被隐藏
     */
    public static final Integer TEMPLATE_NONE = -1;
    public static final Integer TEMPLATE_1 = 1;
    public static final Integer TEMPLATE_2 = 2;
    public static final Integer TEMPLATE_3 = 3;
    public static final Integer TEMPLATE_4 = 4;
    public static final Integer TEMPLATE_5 = 5;


    /**
     * 私信状态： 0 删除 1 正常 2 私信发送人删除  3 私信接收人删除   4 双方都删除
     */

    public static final Integer STATUS_DELETE = 0;
    public static final Integer STATUS_UNDELETE = 1;
    public static final Integer STATUS_SENDDELETE = 2;
    public static final Integer STATUS_RECEIVEDELETE = 3;
    public static final Integer STATUS_ALLDELETE = 4;


    public static final int Oid_None = -1;


    private Long id;

    private Long sendId = 0L;


    private Long receiveId = 0L;


    private String sendName = "admin";


    private String receiveName;


    private String content;


    private Integer status = STATUS_UNDELETE;


    private Integer unread = Status_Unread;


    private String type;

    /*
    * 消息模板
    */
    private Integer template = TEMPLATE_NONE;


    private Long relationId;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    private Long updateAt = 0L;


    private Long createAt = 0L;


    private Integer unreadCount = 0;

    //消息未读数
    @Transient
    public Integer getunreadCount() {
        return unreadCount;
    }

    public void setunreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
    }

    public Message() {
    }

    public Message(Long receiveId, String receiveName, String type, Long relationId) {
        this.receiveId = receiveId;
        this.receiveName = receiveName;
        this.type = type;
        this.relationId = relationId;
    }

    public Message(Long receiveId, String receiveName, String content, String type, Long relationId) {
        this.receiveId = receiveId;
        this.receiveName = receiveName;
        this.content = content;
        this.type = type;
        this.relationId = relationId;
    }


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "send_id")
    public Long getSendId() {
        return sendId;
    }


    public void setSendId(Long sendId) {
        this.sendId = sendId;
    }

    @Column(name = "receive_id")
    public Long getReceiveId() {
        return receiveId;
    }


    public void setReceiveId(Long receiveId) {
        this.receiveId = receiveId;
    }

    @Column(name = "send_name")
    public String getSendName() {
        return sendName;
    }


    public void setSendName(String sendName) {
        this.sendName = sendName;
    }

    @Column(name = "receive_name")
    public String getReceiveName() {
        return receiveName;
    }


    public void setReceiveName(String receiveName) {
        this.receiveName = receiveName;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "unread")
    public Integer getUnread() {
        return unread;
    }

    public void setUnread(Integer unread) {
        this.unread = unread;
    }

    @Column(name = "type")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name = "template")
    public Integer getTemplate() {
        return template;
    }

    public void setTemplate(Integer template) {
        this.template = template;
    }

    @Column(name = "relation_id")
    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

