package com.ptteng.common.skill.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.UserScore;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface UserScoreService extends BaseDaoService {



	public Long insert(UserScore userScore)throws ServiceException, ServiceDaoException;



	public List<UserScore> insertList(List<UserScore> userScoreList)throws ServiceException, ServiceDaoException;



	public boolean delete(Long id)throws ServiceException, ServiceDaoException;



	public boolean update(UserScore userScore)throws ServiceException, ServiceDaoException;



	public boolean updateList(List<UserScore> userScoreList)throws ServiceException, ServiceDaoException;



	public UserScore getObjectById(Long id)throws ServiceException, ServiceDaoException;



	public List<UserScore> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserScoreIdsByUid(Long uid)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserScoreIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserScoreIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserScoreIds() throws ServiceException, ServiceDaoException;


}

