package com.ptteng.common.skill.model;

import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/*
 *  constant为后台常量表   constants为公共常量
 */
@Entity
@Table(name = "constants")
public class Constants implements Serializable {


    /**
     * 状态
     * 0 下架/隐藏
     * 1 上架/展示
     * 2 删除
     */
    public static final Integer STATUS_HIDE = 0;
    public static final Integer STATUS_SHOW = 1;
    public static final Integer STATUS_DELETE = 2;


    /**
     * 排序
     * 0 倒序
     * 1 正序
     */
    public static final Integer SORT_DESC = 0;
    public static final Integer SORT_ASE = 1;


    /**
     * isLike 点赞状态
     * 0 未点赞
     * 1 已点赞
     */
    public static final Integer IS_LIKE_FALSE = 0;
    public static final Integer IS_LIKE_TRUE = 1;

    /*
    * 域名 技能树、小日报、坑乎
    */

    public static final String URL_JNSHU_ONLINE = "http://www.jnshu.com";
    public static final String URL_JNSHU_TEST = "http://test.skill.jnshu.com";
    public static final String URL_JNSHU_DEV = "http://dev.home.skill.jnshu.com";
    public static final String URL_DAILY_ONLINE = "http://daily.jnshu.com";
    public static final String URL_DAILY_TEST = "http://test.daily.skill.jnshu.com";
    public static final String URL_DAILY_DEV = "http://dev.daily.skill.jnshu.com";
    public static final String URL_KENGHU_ONLINE = "http://kenghu.jnshu.com";
    public static final String URL_KENGHU_TEST = "http://test.kenghu.skill.jnshu.com";
    public static final String URL_KENGHU_DEV = "http://dev.kenghu.skill.jnshu.com";


    /**
     * query 查询方式
     * 1 精确查询
     * 2 模糊查询
     */
    public static final Integer QUERY_REFINED  = 1;
    public static final Integer QUERY_FUZZY = 2;

    /**
     * 各种默认id
     * TASK_ID_None  -1   通用任务，用于通用标签
     */
    public static final Long TASK_ID_None = -1L;

}

