package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "article")
public class Article implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 746934008538792960L;

    //类型日报
    public static final String TYPE_DAILT = "daily";
    //动作:喜欢/不喜欢
    public static final String LOVE="love";
    public static final String DISLIKE="dislike";
    public static final String TYPE_PAPER = "paper";


    public static final int Comment_None = 0;


    private Long id;


    private Long cid;


    private Long uid;


    private Long oid;
    
    private String tids;


    private String type;


    private Long pid;


    private String content;


    private String resultsUrl;


    private String codeUrl;


    private Long reply;


    private Long readCount;


    private Long updateTime;


    private Long dailyTime;


    private Long lastReply;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    private  Integer teacherComment = Article.Comment_None;
    private Integer evaluation;
    private Long evaluationUid;
    private Long evaluationAt;
    private Integer love=0;
    private Integer collection=0;


    private boolean ifLike=false;


    private boolean ifCollection=false;

    //晨报
    private Long teamId;
    private Integer status;
    private Long seniorId;

    @Column(name = "senior_id")
    public Long getSeniorId() {
        return seniorId;
    }
    public void setSeniorId(Long seniorId) {
        this.seniorId = seniorId;
    }

    @Column(name = "team_id")
    public Long getTeamId() {
        return teamId;
    }
    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Transient
    public boolean isIfLike() {
        return ifLike;
    }

    public void setIfLike(boolean ifLike) {
        this.ifLike = ifLike;
    }

    @Transient
    public boolean isIfCollection() {
        return ifCollection;
    }

    public void setIfCollection(boolean ifCollection) {
        this.ifCollection = ifCollection;
    }

    @Column(name = "teacher_comment")
    public Integer getTeacherComment() {
        return teacherComment;
    }


    public void setTeacherComment(Integer teacherComment) {
        this.teacherComment = teacherComment;
    }


    @Column( name = "evaluation")
    public Integer getEvaluation() {
        return evaluation;
    }

    public void setEvaluation(Integer evaluation) {
        this.evaluation = evaluation;
    }
    @Column( name = "evaluation_uid")
    public Long getEvaluationUid() {
        return evaluationUid;
    }

    public void setEvaluationUid(Long evaluationUid) {
        this.evaluationUid = evaluationUid;
    }
    @Column( name = "evaluation_at")
    public Long getEvaluationAt() {
        return evaluationAt;
    }

    public void setEvaluationAt(Long evaluationAt) {
        this.evaluationAt = evaluationAt;
    }
    @Column( name = "love")
    public Integer getLove() {
        return love;
    }

    public void setLove(Integer love) {
        this.love = love;
    }
    @Column( name = "collection")
    public Integer getCollection() {
        return collection;
    }

    public void setCollection(Integer collection) {
        this.collection = collection;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "cid")
    public Long getCid() {
        return cid;
    }


    public void setCid(Long cid) {
        this.cid = cid;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "oid")
    public Long getOid() {
        return oid;
    }

    public void setOid(Long oid) {
        this.oid = oid;
    }
    
    
    
    
    @Column(name = "tids")
    public String getTids() {
		return tids;
	}


	public void setTids(String tids) {
		this.tids = tids;
	}


	@Column(name = "type")
    public String getType() {
        return type;
    }


    public void setType(String type) {
        this.type = type;
    }

    @Column(name = "pid")
    public Long getPid() {
        return pid;
    }


    public void setPid(Long pid) {
        this.pid = pid;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "results_url")
    public String getResultsUrl() {
        return resultsUrl;
    }

    public void setResultsUrl(String resultsUrl) {
        this.resultsUrl = resultsUrl;
    }

    @Column(name = "code_url")
    public String getCodeUrl() {
        return codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    @Column(name = "reply")
    public Long getReply() {
        return reply;
    }


    public void setReply(Long reply) {
        this.reply = reply;
    }

    @Column(name = "read_count")
    public Long getReadCount() {
        return readCount;
    }

    public void setReadCount(Long readCount) {
        this.readCount = readCount;
    }

    @Column(name = "update_time")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @Column(name = "daily_time")
    public Long getDailyTime() {
        return dailyTime;
    }

    public void setDailyTime(Long dailyTime) {
        this.dailyTime = dailyTime;
    }

    @Column(name = "last_reply")
    public Long getLastReply() {
        return lastReply;
    }

    public void setLastReply(Long lastReply) {
        this.lastReply = lastReply;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

