/**
 *
 */
package com.ptteng.sca.common.skill.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.skill.model.Qa;
import com.ptteng.common.skill.service.QaService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class QaSCAClient implements QaService {

    private QaService qaService;

    public QaService getQaService() {
        return qaService;
    }


    public void setQaService(QaService qaService) {
        this.qaService = qaService;
    }


    @Override
    public Long insert(Qa qa) throws ServiceException, ServiceDaoException {

        return qaService.insert(qa);


    }


    @Override
    public List<Qa> insertList(List<Qa> qaList) throws ServiceException, ServiceDaoException {

        return qaService.insertList(qaList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return qaService.delete(id);


    }


    @Override
    public boolean update(Qa qa) throws ServiceException, ServiceDaoException {

        return qaService.update(qa);


    }


    @Override
    public boolean updateList(List<Qa> qaList) throws ServiceException, ServiceDaoException {

        return qaService.updateList(qaList);


    }


    @Override
    public Qa getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return qaService.getObjectById(id);


    }


    @Override
    public List<Qa> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return qaService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getQaIdsByOidAndTid(Long oid, Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return qaService.getQaIdsByOidAndTid(oid, tid, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countQaIdsByOidAndTid(Long oid, Long tid) throws ServiceException, ServiceDaoException {

        return qaService.countQaIdsByOidAndTid(oid, tid);


    }


    @Override
    public List<Long> getQaIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return qaService.getQaIds(start, limit);
    }

    @Override
    public Integer countQaIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return qaService.countQaIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return qaService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return qaService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        qaService.deleteList(clz, ids);

    }


}

