package com.ptteng.common.skill.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3963145948088947712L;

    public static final String TYPE_None = "none";
    
    public static final Long TeacherID_None = -1L;

    public static final int Level_None = 10;

    public static final int Status_Student = -1;

    public static final int Status_Teacher = 1;

    public static final Long Occupation_None = -1L;

    public static final int Daily_None = 0;

    public static final String  Rate_Zero = "0.0000";

    /**
     * 无当前所在班级
     */
    public static final Long Classes_None=-1L;
    
    
    /**
     * 无学号
     */
    public static final Integer Study_Number_None=-1;
    
    
    
    private Long id;


    private String nick;


    private String qq;


    private String mobile;


    private String pwd;


    private Long sex;


    private String thumb;


    private Integer isLook;


    private String sign;


    private Long birthday;


    private String school;


    private String province;


    private String city;


    /**
     * 类型 0 :none, 无班级 1:online  散修班 ,2:outside  外门班 ,3:offline 内门班
     */
    private String type = User.TYPE_None;
    
    
    /**
     * 学号，在用户表里冗余一份，方便查询
     */
    private int studyNumber;
    
    /**
     * 日报数量
     */
    private int dailyCount = User.Daily_None;

    private String dailyRate = User.Rate_Zero;
    
    /**
     * 最新的班级ID，为负代表着当前没有班级
     */
    private Long cid=User.Classes_None;
    
    
    /**
     * 最新的用户和班级关联表ID，为负代表着当前没有班级
     */
    private Long userClassID=User.Classes_None;

    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    private  Long oid = User.Occupation_None;


    private  Integer level = User.Level_None;


    private  Long teacherId = User.TeacherID_None;


    private  Integer status = User.Status_Student;


    private Long startAt;

    @Transient
    public String getDailyRate() {
        return dailyRate;
    }

    public void setDailyRate(String dailyRate) {
        this.dailyRate = dailyRate;
    }

    @Column(name = "start_at")
    public Long getStartAt() {
        return startAt;
    }

    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    @Column(name = "oid")
    public Long getOid() {
        return oid;
    }


    public void setOid(Long oid) {
        this.oid = oid;
    }

    @Column(name = "level")
    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    @Column(name = "teacher_id")
    public Long getTeacherId() {
        return teacherId;
    }

    public void setTeacherId(Long teacherId) {
        this.teacherId = teacherId;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }



    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "nick")
    public String getNick() {
        return nick;
    }


    public void setNick(String nick) {
        this.nick = nick;
    }

    @Column(name = "qq")
    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "pwd")
    public String getPwd() {
        return pwd;
    }


    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @Column(name = "sex")
    public Long getSex() {
        return sex;
    }


    public void setSex(Long sex) {
        this.sex = sex;
    }

    @Column(name = "thumb")
    public String getThumb() {
        return thumb;
    }


    public void setThumb(String thumb) {
        this.thumb = thumb;
    }

    @Column(name = "sign")
    public String getSign() {
        return sign;
    }


    public void setSign(String sign) {
        this.sign = sign;
    }

    @Column(name = "birthday")
    public Long getBirthday() {
        return birthday;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    @Column(name = "school")
    public String getSchool() {
        return school;
    }

    public void setSchool(String school) {
        this.school = school;
    }

    @Column(name = "province")
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    @Column(name = "city")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    
    
    
    
    @Column(name = "type")
    public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "daily_count")
	public int getDailyCount() {
		return dailyCount;
	}


	public void setDailyCount(int dailyCount) {
		this.dailyCount = dailyCount;
	}
	
	
	


	@Column(name = "cid")
	public Long getCid() {
		return cid;
	}


	public void setCid(Long cid) {
		this.cid = cid;
	}
	
	
	
	

	@Column(name = "study_number")
	public int getStudyNumber() {
		return studyNumber;
	}


	public void setStudyNumber(int studyNumber) {
		this.studyNumber = studyNumber;
	}


	@Column(name = "user_class_id")
	public Long getUserClassID() {
		return userClassID;
	}


	public void setUserClassID(Long userClassID) {
		this.userClassID = userClassID;
	}


	@Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }



    @Column(name = "is_look")
    public Integer getIsLook() {
        return isLook;
    }

    public void setIsLook(Integer isLook) {
        this.isLook = isLook;
    }







    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

