package com.ptteng.controller.UserParam;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.HashMap;
import java.util.Map;

public class UserParam {
    private Long id;
    private Long uid;
    private String occupation;
    private String type;
    private Long studyNumber;
    private String name;
    private String identity;
    private String status;
    private String mobile;
    private String createAt;
    private String studyAt;
    private String graduateAt;
    private Integer hours;
    private Integer score;
    private Long recommendId;
    private Integer recommendCount;
    private String source;

    private final Map<String, String> config = new HashMap<>();
    private final String[] keys = new String[]{"uid", "name", "occupation", "type", "studyNumber", "name", "identity", "status",
            "mobile", "createAt", "studyAt", "graduateAt", "hours", "score", "recommendId", "recommendCount", "source"};

    public UserParam() {
        config.put("uid", "ID");
        config.put("occupation", "职业");
        config.put("type", "班级");
        config.put("studyNumber", "学号");
        config.put("name", "昵称");
        config.put("identity", "身份");
        config.put("status", "状态");
        config.put("mobile", "手机号");
        config.put("createAt", "注册时间");
        config.put("studyAt", "入学时间");
        config.put("graduateAt", "结业时间");
        config.put("hours", "请假");
        config.put("score", "总积分");
        config.put("recommendId", "推荐人ID");
        config.put("recommendCount", "推荐人数");
        config.put("source", "报名渠道");
    }

    public Map<String, String> getConfig() {
        return config;
    }

    public String[] getKeys() {
        return keys;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getOccupation() {
        return occupation;
    }

    public void setOccupation(String occupation) {
        this.occupation = occupation;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getStudyNumber() {
        return studyNumber;
    }

    public void setStudyNumber(Long studyNumber) {
        this.studyNumber = studyNumber;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentity() {
        return identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getCreateAt() {
        return createAt;
    }

    public void setCreateAt(String createAt) {
        this.createAt = createAt;
    }

    public String getStudyAt() {
        return studyAt;
    }

    public void setStudyAt(String studyAt) {
        this.studyAt = studyAt;
    }

    public String getGraduateAt() {
        return graduateAt;
    }

    public void setGraduateAt(String graduateAt) {
        this.graduateAt = graduateAt;
    }

    public Integer getHours() {
        return hours;
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public Long getRecommendId() {
        return recommendId;
    }

    public void setRecommendId(Long recommendId) {
        this.recommendId = recommendId;
    }

    public Integer getRecommendCount() {
        return recommendCount;
    }

    public void setRecommendCount(Integer recommendCount) {
        this.recommendCount = recommendCount;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}
