package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.ReviewService;
import com.ptteng.common.skill.service.UeventService;
import com.ptteng.common.skill.util.ReviewUtil;
import com.ptteng.common.skill.util.UEventUtil;
import com.ptteng.util.ComputeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Review crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ReviewController {
	private static final Log log = LogFactory.getLog(ReviewController.class);

	@Autowired
	private ReviewService reviewService;

	@Autowired
	private UeventService ueventService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/u/review/search", method = RequestMethod.GET)
	public String getReviewIdsByUidJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size, Long rid, Long branchID, Long uid, String unick,
			String uphone, Long occouptionID, Long minReviewStartAt,
			Long maxReviwStartAt, Long reviewerID, String reviewerNick,
			String reviewerPhone, Integer type, Integer status)
			throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);
		Long total = 0L, totalPage = 1L;

		try {

			Map<String, Object> paramList = ReviewUtil.getDynamicParam(rid,
					branchID, uid, unick, uphone, occouptionID,
					minReviewStartAt, maxReviwStartAt, reviewerID,
					reviewerNick, reviewerPhone, type, status, false);
			log.info("get param:" + paramList);

			List<Long> wids = reviewService.getIdsByDynamicCondition(
					Week.class, paramList, start, size);
			log.info("get wids:" + wids);

			Map<String, Object> paramCount = ReviewUtil.getDynamicParam(rid,
					branchID, uid, unick, uphone, occouptionID,
					minReviewStartAt, maxReviwStartAt, reviewerID,
					reviewerNick, reviewerPhone, type, status, true);

			log.info("get param:" + paramList);
			List<Long> count = reviewService.getIdsByDynamicCondition(
					User.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("get wids:" + count);
			/* 获取total、totalPage */
			if (org.apache.commons.collections.CollectionUtils
					.isNotEmpty(count)) {
				total = count.get(0);
				totalPage = ComputeUtil.myDivideiCeil(total, size);
			}

			List<Review> reviewList = reviewService.getObjectsByIds(wids);
			log.info("get review data is " + reviewList.size());

			log.info("get review count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("reviewList", reviewList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get review list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/review/json/reviewListJson";
	}

	@RequestMapping(value = "/a/u/review/{id}/detail", method = RequestMethod.GET)
	public String getReviewJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Review review = reviewService.getObjectById(id);
			log.info("get review data is " + review);

			model.addAttribute("code", 0);

			model.addAttribute("review", review);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get review error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/review/json/reviewDetailJson";
	}

	@RequestMapping(value = "/a/u/review/{id}", method = RequestMethod.PUT)
	public String updateReviewJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Review review)
			throws Exception {

		log.info("update review : review= " + review);

		Manager manager = (Manager) request.getAttribute("manager");
		try {
			review.setUpdateBy(manager.getId());
			Review oldReview = this.reviewService.getObjectById(review.getId());
			review.setCreateBy(oldReview.getCreateBy());
			review.setCreateAt(oldReview.getCreateAt());
			reviewService.update(review);

			model.addAttribute("code", 0);

			model.addAttribute("review", review);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update review error,id is  " + review.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}
	


	@RequestMapping(value = "/a/u/review", method = RequestMethod.POST)
	public String addReviewJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Review review)
			throws Exception {

		log.info("update review : review= " + review);
		Long id = null;
		Manager manager = (Manager) request.getAttribute("manager");
		try {
			review.setId(null);
			review.setCreateBy(manager.getId());
			review.setUpdateBy(manager.getId());
			if (review != null) {

				review.setId(null);

				id = reviewService.insert(review);
				model.addAttribute("code", 0);

				int eventType = UEventUtil.convertReviewType2EventType(review);
				if (eventType != -1) {
					Uevent event = new Uevent(review.getUid(), eventType,
							System.currentTimeMillis(), "");
					Long eid = this.ueventService.insert(event);
					log.info(review.getUid() + " insert event " + id + " is "
							+ event);
				} else {

				}

			} else {
				log.info(" week is null ");
				model.addAttribute("code", -1000);
			}
			model.addAttribute("id", id);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add review error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/review/{id}", method = RequestMethod.DELETE)
	public String deleteReviewJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete review : id= " + id);
		try {
			reviewService.delete(id);

			log.info("add review success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete review error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/multi/review", method = RequestMethod.GET)
	public String getMultiReviewJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<Review> reviewList = reviewService.getObjectsByIds(idList);
			log.info("get  review data is " + reviewList);

			model.addAttribute("code", 0);
			model.addAttribute("total", reviewList.size());

			model.addAttribute("reviewList", reviewList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get review error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/review/json/reviewListJson";
	}

}
