package com.ptteng.controller;

//import com.fasterxml.jackson.databind.ObjectMapper;

import com.ptteng.common.skill.model.DeepThink;
import com.ptteng.common.skill.model.Manager;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.Task;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * OccupationType  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class OccupationController {
    private static final Log log = LogFactory.getLog(OccupationController.class);

    @Autowired
    private OccupationService occupationService;


    @Autowired
    private TaskService taskService;

    @Autowired
    private SkillService skillService;

    @Autowired
    private TaskSkillRelationService taskSkillRelationService;
    @Autowired
    private ManagerService managerService;
    @Autowired
    private DeepThinkService deepThinkService;

    /**
     * 职业列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param name
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/occupation/search/query", method = RequestMethod.GET)
    public String getOccupationList(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Integer page,
                                    Integer size, String name, Long id) throws Exception {
        log.info("pageList : page= " + page + " , size=" + size + " name = " + name + " id : " + id);
        if (page == null) {

            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            Map<String, Object> map = DynamicUtil.getOccupatoinListParam(id, name, false);
            log.info("  map = " + map);
            List<Long> ids = occupationService.getIdsByDynamicCondition(Occupation.class, map, start, size);

            log.info("get Occupation size is " + ids.size());


            Integer totalSize = (occupationService.getIdsByDynamicCondition(Occupation.class, map, 0, Integer.MAX_VALUE)).size();

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("total", totalSize);
            model.addAttribute("size", size);

            if (CollectionUtils.isEmpty(ids)) {
                model.addAttribute("list", new ArrayList());

            } else {
                List<Occupation> occupations = occupationService.getObjectsByIds(ids);
                model.addAttribute("list", occupations);
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get manager list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/occupation/json/occupationListJson";
    }

    /**
     * 新增职业
     *
     * @param request
     * @param response
     * @param model
     * @param occupation
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/occupation", method = RequestMethod.POST)
    public String addOccupation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                Occupation occupation) throws Exception {
        log.info("addOccupation occupation :" + occupation + "]");

        try {
            Manager manager = (Manager) request.getAttribute("manager");
            Long managerId = manager.getId();
            occupation.setPublishAt(System.currentTimeMillis());
            occupation.setCreateBy(managerId);
            occupation.setUpdateBy(managerId);
            if (StringUtils.isEmpty(occupation.getBrief())) {
                occupation.setBrief("无");
            }
            log.info(" occupation1 = " + occupation);
            Long id = occupationService.insert(occupation);
            log.info("id: " + id);

            model.addAttribute("code", 0);
            model.addAttribute("id", id);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("addOccupation error");
            model.addAttribute("code", -1);
        }


        return "/common/insert";
    }


    /**
     * 修改职业提问模块
     *
     * @param request
     * @param response
     * @param model
     * @param questionModules
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/questionModules/{oid}", method = RequestMethod.PUT)
    public String addOccupation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                String questionModules, @PathVariable Long oid) throws Exception {

        if (oid == null) {
            model.addAttribute("code", -23001);
            log.info("oid is null");
            return "/common/failure";
        }

        if (questionModules == null) {
            model.addAttribute("code", -23002);
            log.info("questionModules is null");
            return "/common/failure";
        }

        try {
            Manager manager = (Manager) request.getAttribute("manager");
            if (DataUtils.isNullOrEmpty(manager)) {
                log.info("get manager error :manager is null");
                model.addAttribute("code", -3);
                return "/common/failure";
            }

            Occupation occupation = occupationService.getObjectById(oid);
            if (DataUtils.isNullOrEmpty(occupation)) {
                log.info("get occupation error :occupation is null");
                model.addAttribute("code", -23003);
                return "/common/failure";
            }
            occupation.setQuestionModules(questionModules);
            occupation.setUpdateBy(manager.getId());
            boolean isUpdate = occupationService.update(occupation);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("addOccupation error");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    /**
     * 查询单个职业简介
     *
     * @param request
     * @param response
     * @param model
     * @param oid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/occupation/{oid}", method = RequestMethod.GET)
    public String getOccupation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                @PathVariable Long oid) throws Exception {
        log.info("getOccupation [oid:" + oid + "]");

        try {

            Occupation occupation = occupationService.getObjectById(oid);
            log.info("occupation: " + occupation);

            model.addAttribute("code", 0);

            model.addAttribute("occupation", occupation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("getOccupation error");
            model.addAttribute("code", -1);
        }


        return "/common-skill-service/occupation/json/occupationDetailJson";
    }


    /**
     * 修改职业
     *
     * @param request
     * @param response
     * @param model
     * @param oid
     * @param typeId
     * @param occupatoin
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/occupation/{oid}", method = RequestMethod.PUT)
    public String updateOccupation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                   @PathVariable Long oid, Long typeId, Occupation occupatoin) throws Exception {

        try {
            log.info("update: " + occupatoin);
            Manager manager = (Manager) request.getAttribute("manager");
            occupatoin.setUpdateBy(manager.getId());
            log.info("update: " + occupatoin);
            boolean update = occupationService.update(occupatoin);
            log.info("update: " + update);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("addOccupation error");
            model.addAttribute("code", -1);
        }


        return "/common/success";
    }


    /**
     * 删除单个职业
     *
     * @param request
     * @param response
     * @param model
     * @param oid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/occupation/{oid}", method = RequestMethod.DELETE)
    public String deleteOccupation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                   @PathVariable Long oid) throws Exception {

        try {
            if (oid == null) {
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            //如果该职业下有关联的小课堂则不能删除
            Map<String, Object> deepThinkParam = DynamicUtil.getDeepThinkParam(oid, null, null, false);
            log.info("deepThinkParam=" + deepThinkParam);
            List<Long> ids = deepThinkService.getIdsByDynamicCondition(DeepThink.class, deepThinkParam, 0, Integer.MAX_VALUE);
            log.info("ids=" + ids);
            //如果任务下有深度思考则不能删除
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(ids)){
                model.addAttribute("code", -80001);
                return "/common/success";
            }

            //是否还需删除相关技能和任务

            occupationService.delete(oid);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("addOccupation error");
            model.addAttribute("code", -1);
        }


        return "/common/success";
    }


    /**
     * 职业任务列表
     *
     * @param request
     * @param response
     * @param model
     * @param oid
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/occupation/{oid}/task", method = RequestMethod.GET)
    public String getSkill(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model, @PathVariable Long oid, Integer page, Integer size) throws Exception {

        log.info("get task list : oid = " + oid);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        try {

            log.info("the class ======---------");
            List<Long> taskIds = taskService.getTaskIdsByOid(oid, start, size);

            if (taskIds == null) {
                log.info("the task skill is null");
                model.addAttribute("code", -6007);
                return "/common/success";
            }

            List<Task> tasks = taskService.getObjectsByIds(taskIds);

            log.info("tasks count is" + tasks.size());
            Integer total = taskService.countTaskIdsByOid(oid);

            log.info("the total count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("tasks", tasks);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add skill error ");
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/task/json/taskListJson";
    }

}

