package com.ptteng.util;

import com.qding.common.util.DataUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by liangxj on 2015/9/7.
 */
public class ReadIndentUtil {

    public static Map<String, Object> getIndentIds(String product, String texture, String size, String indentity,
                                                   Integer status, Integer begin_time, Integer finish_time, Boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(product)) {
            params.put("product", " '%" + product + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(texture)) {
            params.put("texture", "'%" + texture + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(size)) {
            params.put("size", " '" + size + "' ");
        }
        if (DataUtils.isNotNullOrEmpty(indentity)) {
            params.put("indentity", " '%" + indentity + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", " '%" + status + "%' ");
        }
        if (DataUtils.isNotNullOrEmpty(begin_time)) {
            params.put("create_at & >=", " '" + begin_time + "' ");
        }
        if (DataUtils.isNotNullOrEmpty(finish_time)) {
            params.put("create_at & <=", " '" + finish_time + "' ");
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  indent ");

        return params;
    }

}
