package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.ClassTimetable;
import com.ptteng.common.skill.service.ClassTimetableService;
import com.ptteng.util.DynamicUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @Description 后台相关数据统计的接口
 * @Author ruanshaonan
 * @Date 2018/6/29 17:28
 **/

@Controller
public class StatisticController {
    private static final Log log = LogFactory.getLog(StatisticController.class);

    @Autowired
    private ClassTimetableService classTimetableService;

    /**
     * 小课堂数据统计
    *@Author ruanshaonan
    *@Description
    *@Date 21:25 2018/7/1
    *@Param oid：职业id
    *@Param tid：任务id
    *@Param level：评级
    *@Param classTeamName：小组名
    *@Param startTime：开始时间
    *@Param endTime：结束时间
    *@Param speakerName：主讲人姓名
    *@Param thinkName：课题名称
    */
    @RequestMapping(value = "/a/u/class/statistics",method = RequestMethod.GET)
    public String getClassStatistic(HttpServletRequest request,  HttpServletResponse response, ModelMap model,
                                    Long oid, Long tid, Integer level, Long classTeamId, Long startTime,
                                    Long endTime, String speakerName, String thinkName) throws ServiceException, ServiceDaoException {
        log.info("getClassStatistic==");

        log.info("getClassStatistic=oid=" + oid + "=tid=" + tid + "=level=" + level + "=classTeamId="
                + classTeamId + "=startTime=" + startTime + "=endTime=" + endTime + "=speakerName="
                + speakerName + "=thinkName=" + thinkName );

        try {
            Map<String, Object> classTimetableListParam = DynamicUtil.getClassTimetableParam(oid, tid, level, classTeamId,
                    startTime, endTime, speakerName, thinkName,false);
            log.info("classTimetableListParam=" + classTimetableListParam);
            List<Long> totalIds = classTimetableService.getIdsByDynamicCondition(ClassTimetable.class, classTimetableListParam, 0, Integer.MAX_VALUE);
            log.info("totalIds=" + totalIds.size());
            int  total = totalIds.size();

            List<ClassTimetable> classArrangeList = classTimetableService.getObjectsByIds(totalIds);
            log.info("getClassTimetableList success=" + classArrangeList.size());

            //四个等级的小课堂数量统计
            int highCount = 0;
            int middleCount = 0;
            int lowCount = 0;
            int noLevelCount = 0;

            if (CollectionUtils.isNotEmpty(classArrangeList)) {
                for (ClassTimetable classTimetable : classArrangeList) {
                    if (classTimetable.getLevel() == ClassTimetable.HIGH_LEVEL) {
                        highCount++;
                    }
                    if (classTimetable.getLevel() == ClassTimetable.MIDDLE_LEVEL) {
                        middleCount++;
                    }
                    if (classTimetable.getLevel() == ClassTimetable.LOW_LEVEL) {
                        lowCount++;
                    }
                }
            }
            noLevelCount = total - highCount - middleCount - lowCount;

            log.info("total=" + total + "=highCount=" + highCount + "=middleCount=" + middleCount + "=lowCount="
                    + lowCount + "=noLevelCount=" + noLevelCount);

            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("highCount", highCount);
            model.addAttribute("middleCount", middleCount);
            model.addAttribute("lowCount", lowCount);
            model.addAttribute("noLevelCount", noLevelCount);
        }catch (Throwable throwable){
            log.info("getClassStatistic fail =="+throwable.getMessage());
            model.addAttribute("code", -100000);
            return "/common/success";
        }
        return "/common-skill-service/classTimetable/json/classTimetableStatistic";
    }
}
