package com.ptteng.controller;

import com.ptteng.common.skill.model.Leaves;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.LeavesService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.LogUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Leaves  crud
 */
@Controller
public class LeavesController {
    private static final Log log = LogFactory.getLog(LeavesController.class);

    @Autowired
    private LeavesService leavesService;
    @Autowired
    private UserService userService;
    @Autowired
    private OccupationService occupationService;
    @Autowired
    private CookieUtil cookieUtil;


    //	1 新增请假
    @RequestMapping(value = "/a/u/leaves", method = RequestMethod.POST)
    public String addLeavesJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model,
                                Leaves leaves
    ) throws Exception {
        //打印入参
        log.info("============================================");
        log.info("new leaves : leaves= " + leaves);

        if (leaves.getUid() == null) {
            model.addAttribute("code", -19000);
            log.info("uid is null");
            return "/common/success";
        }

        if (leaves.getHours() == null) {
            model.addAttribute("code", -19001);
            log.info("hours is null");
            return "/common/success";
        }
        if (leaves.getStartAt() == null) {
            model.addAttribute("code", -19002);
            log.info("startAt is null");
            return "/common/success";
        }
        if (leaves.getEndAt() == null) {
            model.addAttribute("code", -19003);
            log.info("endAt is null");
            return "/common/success";
        }
        if (leaves.getComments() == null) {
            model.addAttribute("code", -19004);
            log.info("comments is null");
            return "/common/success";
        }

        leaves.setId(null);
        leaves.setStatus(0);
        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

        leaves.setCreateBy(Long.parseLong(userId));
        leaves.setUpdateBy(Long.parseLong(userId));

        /*
        * 获取用户信息
        * 1 判断是否存在
        * 2 判断是否为线下学员
        * 3 判断是否为在学状态
        */
        User user = userService.getObjectById(leaves.getUid());
        if (DataUtils.isNullOrEmpty(user)) {
            log.info("add leaves error :user == null");
            model.addAttribute("code", -5003);
            return "/common/success";
        } else if (!(user.getType().equals(User.TYPE_OFFLINE))) {
            log.info("add leaves error :user type != offline");
            model.addAttribute("code", -19005);
            return "/common/success";
        } else if ((user.getStatus() != User.Status_Student)) {
            log.info("add leaves error :user status != -1 ");
            model.addAttribute("code", -19008);
            return "/common/success";
        }

        try {

            //实例化
            Long LeavesId = leavesService.insert(leaves);
            log.info("LeavesId=" + LeavesId);
            if (LeavesId == null) {
                log.info("add leaves error :LeavesId == null");
                model.addAttribute("code", -1);
                return "/common/success";
            }
            //更新用户状态为请假   -1：在学   1：退学  2 ：待业   3 ：结业   5：请假
            user.setStatus(5);
            userService.update(user);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add leaves error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //2.获取请假详情
    @RequestMapping(value = "/a/u/leaves/{id}", method = RequestMethod.GET)
    public String getLeavesJson(HttpServletRequest request, HttpServletResponse response,
                                ModelMap model, @PathVariable Long id)
            throws Exception {

        //打印入参
        log.info("============================================");
        log.info("get leaves : id=" + id);
        try {
            Leaves leaves = leavesService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(leaves)) {
                log.info("get leaves error :leaves == null");
                model.addAttribute("code", -19007);
                return "/common/success";
            } else {
                log.info("get leaves data is " + leaves);
            }

            model.addAttribute("code", 0);
            model.addAttribute("leaves", leaves);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get leaves error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/leaves/json/leavesDetailJson";
    }


    // 3 销假
    @RequestMapping(value = "/a/u/leaves/{id}", method = RequestMethod.PUT)
    public String updateLeavesJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model,
                                   Leaves leaves,
                                   @PathVariable Long id
    ) throws Exception {

        //打印入参
        log.info("============================================");
        log.info("update leaves : leaves= " + leaves);

        if (id == null) {
            model.addAttribute("code", -19006);
            log.info("id is null");
            return "/common/success";
        }

        if (leaves.getUid() == null) {
            model.addAttribute("code", -19000);
            log.info("uid is null");
            return "/common/success";
        }

        if (leaves.getHours() == null) {
            model.addAttribute("code", -19001);
            log.info("hours is null");
            return "/common/success";
        }
        if (leaves.getStartAt() == null) {
            model.addAttribute("code", -19002);
            log.info("startAt is null");
            return "/common/success";
        }
        if (leaves.getEndAt() == null) {
            model.addAttribute("code", -19003);
            log.info("endAt is null");
            return "/common/success";
        }
        if (leaves.getComments() == null) {
            model.addAttribute("code", -19004);
            log.info("comments is null");
            return "/common/success";
        }


        String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

        Leaves oldLeaves = leavesService.getObjectById(id);
        if (oldLeaves == null) {
            model.addAttribute("code", -19007);
            log.info(id + " leaves is null");
            return "/common/success";
        }


        leaves.setUpdateBy(Long.parseLong(userId));

        /*
        * 获取用户信息
        * 1 判断是否存在
        * 2 判断是否为线下学员
        * 3 判断是否为请假状态
        */
        User user = userService.getObjectById(leaves.getUid());
        if (DataUtils.isNullOrEmpty(user)) {
            log.info("update leaves error :user == null");
            model.addAttribute("code", -5003);
            return "/common/success";
        } else if (!(user.getType().equals(User.TYPE_OFFLINE))) {
            log.info("update leaves error :user type != offline");
            model.addAttribute("code", -19005);
            return "/common/success";
        } else if (!(user.getStatus().equals(User.STATUS_5))) {
            log.info("update leaves error ::user status != 5");
            model.addAttribute("code", -19009);
            return "/common/success";
        }

        try {
            leaves.setStatus(1);
            leavesService.update(leaves);
            log.info(id + " leaves update success");

            //更新用户状态为在学   -1：在学   1：退学  2 ：待业   3 ：结业  5：请假
            //更新用户总请假时间

            user.setStatus(-1);
            Integer oldHours = user.getHours();
            Integer newHours = oldHours + leaves.getHours();
            log.info(" oldHours=" + oldHours);
            log.info(" newHours=" + newHours);
            user.setHours(newHours);
            userService.update(user);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update leaves error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    // 4 删除请假记录
    @RequestMapping(value = "/a/u/leaves/{id}", method = RequestMethod.DELETE)
    public String deleteContentsJson(HttpServletRequest request, HttpServletResponse response,
                                     ModelMap model, @PathVariable Long id)
            throws Exception {

        //打印入参
        log.info("============================================");
        log.info("delete leaves : id= " + id);

        if (id == null) {
            model.addAttribute("code", -19006);
            model.addAttribute("message", "id is null");
            return "/common/success";
        }


        try {
            Leaves leaves = leavesService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(leaves)) {
                log.info(" delete leaves error :leaves == null");
                model.addAttribute("code", -19007);
                return "/common/success";
            } else {
                log.info("get leaves data is " + leaves);
            }
            leavesService.delete(id);
            log.info("delete leaves success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete leaves error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    //4 搜索请假列表
    @RequestMapping(value = "/a/u/leaves/search", method = RequestMethod.GET)
    public String searchLeavesList(
            HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long uid, String nick, Long oid, Integer identity, String type,
            Long startAt, Long endAt,Integer status,
            Integer page, Integer size)
            throws Exception {

        //打印入参
        log.info("============================================");
        String paramStr = LogUtil.convertParam("/a/u/leaves/search  by==uid", uid, "nick", nick, "oid", oid,
                "identity", identity, "type", type, "startAt", startAt, "endAt", endAt, "status", status,"page", page, "size", size);
        log.info(paramStr);

        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);

        try {
            //初始值
            List<Long> userIdList = new ArrayList<>();
            List<Long> occupationIdList = new ArrayList<>();
            Long total = 0L;

            //动态查询-获取参数列表
            Map<String, Object> paramList = DynamicUtil.getLeavesListParam(uid, nick, oid, identity, type, startAt, endAt, status,false);
            log.info(" paramList size =  " + paramList.size());
            //获取list
            List<Long> leavesIdList = leavesService.getIdsByDynamicCondition(Leaves.class, paramList, start, size);
            if (CollectionUtils.isEmpty(leavesIdList)) {
                log.info(" leavesIdList is null ");
            } else {
                log.info(" leavesIdList size =  " + leavesIdList.size());
            }
            //获取total
            Map<String, Object> paramCount = DynamicUtil.getLeavesListParam(uid, nick, oid, identity, type, startAt, endAt,status, true);
            log.info("get param:" + paramCount);
            List<Long> leavesIdCount = leavesService.getIdsByDynamicCondition(Leaves.class, paramCount, 0, Integer.MAX_VALUE);
            log.info("get leavesIdCount:" + leavesIdCount.size());
            if (CollectionUtils.isNotEmpty(leavesIdCount)) {
                total = leavesIdCount.get(0);
            }

            //获取leavesList
            List<Leaves> leavesList = leavesService.getObjectsByIds(leavesIdList);


            //获取用户IDList
            int leavesSize = leavesList.size();

            for (int i = 0; i < leavesSize; i++) {
                Leaves leaves = leavesList.get(i);
                userIdList.add(leaves.getUid());
            }
            //获取userList数据
            List<User> userList = userService.getObjectsByIds(userIdList);
            log.info("userList size = " + userList.size());

            //获取全部用户的职业ID
            int userSize = userList.size();
            log.info("userSize" + userSize);
            for (int n = 0; n < userSize; n++) {
                User user = userList.get(n);
                occupationIdList.add(user.getOid());
            }
            log.info("occupationIdList size =" + occupationIdList.size());

            // 获得occupationList
            List<Occupation> occupationList = occupationService.getObjectsByIds(occupationIdList);
            log.info("occupationList size =" + occupationList.size());
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("leavesList", leavesList);
            model.addAttribute("users", userList);
            model.addAttribute("occupations", occupationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get leaves list error,page is " + page + " , size " + size);
            // for test
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/leaves/json/leavesListJson";
    }


}

