package com.ptteng.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.Manager;
import com.ptteng.common.skill.model.Stype;
import com.ptteng.common.skill.model.Symptom;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.Week;
import com.ptteng.common.skill.service.StypeService;
import com.ptteng.common.skill.service.SymptomService;
import com.ptteng.common.skill.service.UserSymptomRelationService;
import com.ptteng.common.skill.util.SymptomUtil;
import com.ptteng.util.ComputeUtil;

/**
 * Symptom  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SymptomController {
	private static final Log log = LogFactory.getLog(SymptomController.class);

	@Autowired
	private SymptomService symptomService;
	@Autowired
	private UserSymptomRelationService userSymptomRelationService;
	@Autowired
	private StypeService stypeService;


	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return
	 */
	
		@RequestMapping(value = "/a/u/symptom/search", method = RequestMethod.GET)
	public String getSymptomIdsByTidJsonList(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, Integer page,
                                             Integer size, Long uid, String uname,String uphone,Long wid,Long tid
				,String tname,Long sid,String sname,String orderBy,
											 String sort) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		List<Long> wids=new ArrayList<>();
		if(wid!=null){
			wids.add(wid);
		}
		try {
			List<Symptom> symptomList = new ArrayList<>();

			Long total = 0L,
					totalPage = 1L;


			Map<String, Object> paramList = SymptomUtil.getDynamicParam(  uid,  uname, uphone,wids, tid
					, tname, sid, sname, orderBy,
					 sort, false);
			log.info("get param:" + paramList);

			List<Long> sids = symptomService.getIdsByDynamicCondition(Week.class, paramList, start, size);
			log.info("get wids:" + wids);

			Map<String, Object> paramCount = SymptomUtil.getDynamicParam(  uid,  uname, uphone,wids, tid
					, tname, sid, sname, orderBy,sort,true);

			log.info("get param:" + paramList);
			List<Long> count = symptomService.getIdsByDynamicCondition(User.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("get wids:" + count);
             /* 获取total、totalPage */
			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(count)) {
				total = count.get(0);
				totalPage = ComputeUtil.myDivideiCeil(total, size);
			}


		   symptomList = symptomService.getObjectsByIds(sids);
			log.info("get symptom data is " + symptomList.size());


			Set<Long> tids=new HashSet();
			for(Symptom symptom:symptomList){
				tids.add(symptom.getTid());	
			}
			
			List<Stype> stypeList=this.stypeService.getObjectsByIds(new ArrayList(tids));
		
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("symptomList", symptomList);
			model.addAttribute("stypeList", stypeList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get symptom list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/symptom/json/symptomListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/u/symptom/{id}/detail", method = RequestMethod.GET)
	public String getSymptomJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Symptom symptom = symptomService.getObjectById(id);
			log.info("get symptom data is " + symptom);

			model.addAttribute("code", 0);

			model.addAttribute("symptom", symptom);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get symptom error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/symptom/json/symptomDetailJson";
	}

	@RequestMapping(value = "/a/u/symptom/{id}", method = RequestMethod.PUT)
	public String updateSymptomJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Symptom symptom) throws Exception {
		
		log.info("update symptom : symptom= " + symptom);
		Manager manager = (Manager) request.getAttribute("manager");
		try {
			symptom.setUpdateBy(manager.getId());
			Symptom oldSymptom=this.symptomService.getObjectById(symptom.getId());
			symptom.setCreateBy(oldSymptom.getCreateBy());
			symptom.setCreateAt(oldSymptom.getCreateAt());
			symptomService.update(symptom);


			model.addAttribute("code", 0);

			model.addAttribute("symptom", symptom);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update symptom error,id is  " + symptom.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/symptom", method = RequestMethod.POST)
	public String addSymptomJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Symptom symptom) throws Exception {
		
		log.info("update symptom : symptom= " + symptom);
		Manager manager = (Manager) request.getAttribute("manager");
		try {
			symptom.setId(null);
			symptom.setCreateBy(manager.getId());
			symptom.setUpdateBy(manager.getId());
			Long id=symptomService.insert(symptom);
			model.addAttribute("id", id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add symptom error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/symptom/{id}", method = RequestMethod.DELETE)
	public String deleteSymptomJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {
		int code=0;
		log.info("delete symptom : id= " + id);
		try {

			//删除的时候,如果已经有人有这种症状了,不允许删除

			boolean result=this.isPermitDeleteSymptom(id);

			if(result){
				symptomService.delete(id);
				log.info("delete stype success: id= " + id);
			}else{
				log.info("delete stype not success,still have symptom: id= " + id);
				code=-81100;
			}


			log.info("add symptom success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete symptom error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	private boolean isPermitDeleteSymptom(Long id) throws ServiceException, ServiceDaoException {
		List<Long> ids=this.userSymptomRelationService.getUserSymptomRelationIdsBySid(id,0,Integer.MAX_VALUE);
		if(CollectionUtils.isEmpty(ids)){
			return true;
		}else{

			log.info(id+" cannot delete,because already has user datas "+ids);
			return false;
		}

	}


	@RequestMapping(value = "/a/multi/symptom", method = RequestMethod.GET)
	public String getMultiSymptomJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Symptom> symptomList = symptomService.getObjectsByIds(idList);
			log.info("get  symptom data is " + symptomList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",symptomList.size());

			model.addAttribute("symptomList", symptomList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get symptom error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/symptom/json/symptomListJson";
	}
	
	
	
	
	
}

